/*
 * Decompiled with CFR 0.152.
 */
package com.qingcha.verifier.core.verifier;

import com.qingcha.verifier.core.VerifierException;
import com.qingcha.verifier.core.VerifyItem;
import com.qingcha.verifier.core.VerifyResponse;
import com.qingcha.verifier.core.utils.StringUtils;
import com.qingcha.verifier.core.verifier.AbstractVerifier;
import com.qingcha.verifier.core.verifier.SelectVerifierOptionsFunction;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class SelectVerifier
extends AbstractVerifier {
    private String waringFormat;
    private static final String SELECT_WARING_FORMAT = "%s\u9009\u9879\u975e\u6cd5";

    public SelectVerifier() {
        super(new ArrayList<VerifyItem>());
    }

    protected SelectVerifier(List<VerifyItem> textData) {
        super(textData);
    }

    @Override
    public Optional<VerifyResponse> test(VerifyItem verifyItem) {
        Object value = verifyItem.getValue();
        String key = verifyItem.getKey();
        String subject = verifyItem.getSubject();
        Object[] append = verifyItem.getAppend();
        if (StringUtils.isBlank(this.waringFormat)) {
            this.waringFormat = SELECT_WARING_FORMAT;
        }
        VerifyResponse response = new VerifyResponse(key, subject, String.format(this.waringFormat, subject));
        Optional<VerifyResponse> verifyFail = Optional.of(response);
        if (value == null) {
            return verifyFail;
        }
        if (value instanceof String) {
            String select = (String)value;
            if (append == null || append.length < 1 || append[0] == null || StringUtils.isBlank(select)) {
                return verifyFail;
            }
            SelectVerifierOptionsFunction optionsFunction = (SelectVerifierOptionsFunction)append[0];
            if (!optionsFunction.options().contains(select)) {
                return verifyFail;
            }
            return Optional.empty();
        }
        throw new VerifierException("SelectVerifier\u53ea\u80fd\u6821\u9a8cjava.lang.String");
    }

    @Override
    public void setWaringFormat(String waringFormat) {
        this.waringFormat = waringFormat;
    }
}

