/*
 * Decompiled with CFR 0.152.
 */
package com.qingcha.verifier.core.verifier;

import com.qingcha.verifier.core.VerifierException;
import com.qingcha.verifier.core.VerifyItem;
import com.qingcha.verifier.core.VerifyResponse;
import com.qingcha.verifier.core.utils.StringUtils;
import com.qingcha.verifier.core.verifier.AbstractVerifier;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class NumberVerifier
extends AbstractVerifier {
    private String waringFormat;

    public NumberVerifier() {
        super(new ArrayList<VerifyItem>());
    }

    protected NumberVerifier(List<VerifyItem> items) {
        super(items);
    }

    @Override
    public Optional<VerifyResponse> test(VerifyItem verifyItem) {
        String key = verifyItem.getKey();
        Object value = verifyItem.getValue();
        String subject = verifyItem.getSubject();
        if (StringUtils.isBlank(this.waringFormat)) {
            this.waringFormat = "%s\u6821\u9a8c\u5931\u8d25";
        }
        Optional<VerifyResponse> verifyFail = Optional.of(new VerifyResponse(key, subject, String.format(this.waringFormat, subject)));
        if (value == null) {
            return verifyFail;
        }
        if (value instanceof Number) {
            return Optional.empty();
        }
        throw new VerifierException("NumberVerifier\u53ea\u80fd\u6821\u9a8cjava.lang.Number");
    }

    @Override
    public void setWaringFormat(String waringFormat) {
        this.waringFormat = waringFormat;
    }
}

