/*
 * Decompiled with CFR 0.152.
 */
package com.qingcha.verifier.core.verifier;

import com.qingcha.verifier.core.VerifierException;
import com.qingcha.verifier.core.VerifyItem;
import com.qingcha.verifier.core.VerifyResponse;
import com.qingcha.verifier.core.utils.StringUtils;
import com.qingcha.verifier.core.verifier.AbstractVerifier;
import com.qingcha.verifier.core.verifier.SelectVerifierOptionsFunction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;

public class MultipleSelectVerifier
extends AbstractVerifier {
    private String waringFormat;
    private static final String MULTIPLE_SELECT_WARING_FORMAT = "%s\u9009\u9879\u975e\u6cd5";

    public MultipleSelectVerifier() {
        super(new ArrayList<VerifyItem>());
    }

    public MultipleSelectVerifier(List<VerifyItem> textData) {
        super(textData);
    }

    @Override
    public Optional<VerifyResponse> test(VerifyItem verifyItem) {
        Object value = verifyItem.getValue();
        String key = verifyItem.getKey();
        Object[] append = verifyItem.getAppend();
        String subject = verifyItem.getSubject();
        if (StringUtils.isBlank(this.waringFormat)) {
            this.waringFormat = MULTIPLE_SELECT_WARING_FORMAT;
        }
        VerifyResponse response = new VerifyResponse(key, subject, String.format(this.waringFormat, subject));
        Optional<VerifyResponse> verifyFail = Optional.of(response);
        if (value == null) {
            return verifyFail;
        }
        if (value instanceof Collection) {
            Collection selects = (Collection)value;
            if (append == null || append.length < 1 || append[0] == null) {
                return verifyFail;
            }
            SelectVerifierOptionsFunction optionsFunction = (SelectVerifierOptionsFunction)append[0];
            for (String item : selects) {
                if (optionsFunction.options().contains(item)) continue;
                return verifyFail;
            }
            return Optional.empty();
        }
        throw new VerifierException("MultipleSelectVerifier\u53ea\u80fd\u6821\u9a8cjava.lang.String\u7c7b\u7684java.util.Collection");
    }

    @Override
    public void setWaringFormat(String waringFormat) {
        this.waringFormat = waringFormat;
    }
}

