/*
 * Decompiled with CFR 0.152.
 */
package com.qingcha.verifier.core.verifier;

import com.qingcha.verifier.core.VerifierException;
import com.qingcha.verifier.core.VerifyItem;
import com.qingcha.verifier.core.VerifyResponse;
import com.qingcha.verifier.core.utils.StringUtils;
import com.qingcha.verifier.core.verifier.AbstractVerifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;

public class CollectionVerifier
extends AbstractVerifier {
    private String waringFormat;

    public CollectionVerifier() {
        super(new ArrayList<VerifyItem>());
    }

    protected CollectionVerifier(List<VerifyItem> items) {
        super(items);
    }

    @Override
    public Optional<VerifyResponse> test(VerifyItem verifyItem) {
        String key = verifyItem.getKey();
        Object value = verifyItem.getValue();
        String subject = verifyItem.getSubject();
        if (StringUtils.isBlank(this.waringFormat)) {
            this.waringFormat = "%s\u6821\u9a8c\u5931\u8d25";
        }
        Optional<VerifyResponse> verifyFail = Optional.of(new VerifyResponse(key, subject, String.format(this.waringFormat, subject)));
        if (value == null) {
            return verifyFail;
        }
        if (value instanceof Collection) {
            Collection collection = (Collection)value;
            return collection.isEmpty() ? verifyFail : Optional.empty();
        }
        throw new VerifierException("CollectionVerifier\u53ea\u80fd\u6821\u9a8cjava.util.Collection");
    }

    @Override
    public void setWaringFormat(String waringFormat) {
        this.waringFormat = waringFormat;
    }
}

