/*
 * Decompiled with CFR 0.152.
 */
package com.qingcha.verifier.core.verifier;

import com.qingcha.verifier.core.VerifierException;
import com.qingcha.verifier.core.VerifyItem;
import com.qingcha.verifier.core.VerifyResponse;
import com.qingcha.verifier.core.VerifyResult;
import com.qingcha.verifier.core.verifier.Verifier;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public abstract class AbstractVerifier
implements Verifier {
    protected final String defaultWaringFormat = "%s\u6821\u9a8c\u5931\u8d25";
    private final VerifyResult verifyResult = new VerifyResult();
    private final List<VerifyItem> data;

    protected AbstractVerifier(List<VerifyItem> data) {
        this.data = data;
    }

    protected AbstractVerifier() {
        this.data = new ArrayList<VerifyItem>();
    }

    @Override
    public VerifyResult verify() {
        this.verifyResult.clear();
        this.data.forEach(item -> this.test((VerifyItem)item).ifPresent(this.verifyResult::addWarning));
        return this.verifyResult;
    }

    @Override
    public void verifyWithException() {
        for (VerifyItem verifyItem : this.data) {
            Optional<VerifyResponse> optional = this.test(verifyItem);
            if (!optional.isPresent()) continue;
            throw new VerifierException(optional.get().getWarning());
        }
    }

    public abstract Optional<VerifyResponse> test(VerifyItem var1);

    public List<VerifyItem> getData() {
        return this.data;
    }

    @Override
    public void addDatum(VerifyItem item) {
        this.data.add(item);
    }
}

