/*
 * Decompiled with CFR 0.152.
 */
package com.qingcha.verifier.core;

import com.qingcha.verifier.core.VerifierException;
import com.qingcha.verifier.core.VerifyItem;
import com.qingcha.verifier.core.annotation.SelectionOptions;
import com.qingcha.verifier.core.annotation.VerifierConfig;
import com.qingcha.verifier.core.annotation.VerifyObject;
import com.qingcha.verifier.core.annotation.VerifySubject;
import com.qingcha.verifier.core.utils.StringUtils;
import com.qingcha.verifier.core.verifier.ComplexVerifier;
import com.qingcha.verifier.core.verifier.MultipleSelectVerifier;
import com.qingcha.verifier.core.verifier.SelectVerifier;
import com.qingcha.verifier.core.verifier.SelectVerifierOptionsFunction;
import com.qingcha.verifier.core.verifier.Verifier;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class VerifierBuilder {
    private boolean built;
    private final Map<String, Verifier> verifiers = new HashMap<String, Verifier>(8);
    private final List<String> verifierList = new ArrayList<String>(8);

    public VerifierBuilder add(String verifierName, String key, String subject, Object value, Object ... append) {
        VerifyItem verifyItem = new VerifyItem(key, value, append);
        verifyItem.setSubject(subject);
        Verifier verifier = this.verifiers.get(verifierName);
        if (verifier == null) {
            throw new VerifierException(verifierName + "\u672a\u627e\u5230");
        }
        verifier.addDatum(verifyItem);
        return this;
    }

    public VerifierBuilder addAndPassIfNull(String verifierName, String key, String subject, Object value, boolean passIfNull, Object ... append) {
        if (passIfNull && value == null) {
            return this;
        }
        return this.add(verifierName, key, subject, value, append);
    }

    public VerifierBuilder addVerifier(Verifier verifier) {
        return this.addVerifier(verifier.getClass().getSimpleName(), verifier);
    }

    public VerifierBuilder addVerifier(String verifierName, Verifier verifier) {
        this.verifiers.put(verifierName, verifier);
        this.verifierList.add(verifierName);
        return this;
    }

    public VerifierBuilder verifyObject(Object object) {
        if (object == null) {
            throw new VerifierException("verify object is null");
        }
        Class<?> clazz = object.getClass();
        VerifyObject verifyObject = clazz.getAnnotation(VerifyObject.class);
        if (verifyObject == null) {
            throw new VerifierException("\u9700\u8981\u6821\u9a8c\u7684\u5bf9\u8c61\u6ca1\u6709\u6807\u8bb0@VerifyObject\u6ce8\u89e3");
        }
        VerifierConfig[] config = verifyObject.value();
        try {
            Field[] fields;
            for (VerifierConfig verifierConfig : config) {
                Verifier verifier;
                Class<? extends Verifier> verifierClass = verifierConfig.verifier();
                String name = verifierConfig.name();
                if (StringUtils.isBlank(name)) {
                    name = verifierClass.getSimpleName();
                }
                if ((verifier = this.verifiers.get(name)) == null) {
                    verifier = verifierClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    String warningFormat = verifierConfig.warningFormat();
                    if (!StringUtils.isBlank(warningFormat)) {
                        verifier.setWaringFormat(warningFormat);
                    }
                }
                this.addVerifier(name, verifier);
            }
            for (Field field : fields = clazz.getDeclaredFields()) {
                VerifySubject[] verifySubjects = (VerifySubject[])field.getAnnotationsByType(VerifySubject.class);
                field.setAccessible(true);
                Object value = field.get(object);
                for (VerifySubject verifySubject : verifySubjects) {
                    SelectionOptions selectionOptions;
                    String verifierName = verifySubject.verifierName();
                    if (StringUtils.isBlank(verifierName)) {
                        int verifyIndex = verifySubject.verifyIndex();
                        if (verifyIndex == -1) {
                            Class<? extends Verifier> verifierClass = verifySubject.verifier();
                            if (verifierClass == Verifier.class) {
                                throw new VerifierException("verifier\u3001verifyIndex \u548c verifierName\u5fc5\u987b\u4e09\u9009\u4e00");
                            }
                            verifierName = verifierClass.getSimpleName();
                        } else if (verifyIndex >= 0 && verifyIndex < this.verifiers.size()) {
                            verifierName = this.verifierList.get(verifyIndex);
                        }
                    }
                    Verifier verifier = this.verifiers.get(verifierName);
                    Object[] append = new Object[]{};
                    if ((verifier.getClass() == SelectVerifier.class || verifier.getClass() == MultipleSelectVerifier.class) && (selectionOptions = field.getAnnotation(SelectionOptions.class)) != null) {
                        SelectVerifierOptionsFunction append1 = () -> new ArrayList<String>(Arrays.asList(selectionOptions.value()));
                        append = new Object[]{append1};
                    }
                    this.add(verifierName, field.getName(), verifySubject.subject(), value, append);
                }
            }
        }
        catch (Exception e) {
            throw new VerifierException(e);
        }
        return this;
    }

    public VerifierBuilder warningFormat(String verifierName, String warningFormat) {
        Verifier verifier = this.verifiers.get(verifierName);
        if (verifier == null) {
            throw new VerifierException(verifierName + "\u672a\u627e\u5230");
        }
        verifier.setWaringFormat(warningFormat);
        return this;
    }

    public Verifier build() {
        if (!this.built) {
            this.built = true;
            return new ComplexVerifier(new ArrayList<Verifier>(this.verifiers.values()));
        }
        throw new VerifierException("VerifierBuilder\u5df2\u7ecf\u6784\u5efa\u8fc7\u4e86");
    }
}

