/*
 * Decompiled with CFR 0.152.
 */
package passion.srg;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import javafx.util.Pair;
import passion.asm.MethodDescriptor;
import passion.asm.NameSpecification;
import passion.srg.SrgField;
import passion.srg.SrgMember;
import passion.srg.SrgMethod;

public class SrgMappings {
    private final Map<String, String> packages = new HashMap<String, String>();
    private final Map<String, String> classes = new HashMap<String, String>();
    private final Map<SrgField, SrgField> fields = new HashMap<SrgField, SrgField>();
    private final Map<SrgMethod, SrgMethod> methods = new HashMap<SrgMethod, SrgMethod>();

    public SrgMappings() {
    }

    public void putClass(String a1, String a2) {
        this.getClasses().put(new NameSpecification(a1).jvm(), new NameSpecification(a2).jvm());
    }

    public Map<String, String> getClasses() {
        return this.classes;
    }

    public Map<String, String> getPackages() {
        return this.packages;
    }

    public Map<SrgField, SrgField> getFields() {
        return this.fields;
    }

    public Map<SrgMethod, SrgMethod> getMethods() {
        return this.methods;
    }

    public List<String> lines() {
        ArrayList<String> lines = new ArrayList<String>();
        this.forEachPackage((pack1, pack2) -> lines.add("PK: " + pack1 + " " + pack2));
        this.forEachClass((c1, c2) -> lines.add("CL: " + c1 + " " + c2));
        this.forEachField((f1, f2) -> lines.add("FD: " + f1.toString() + " " + f2.toString()));
        this.forEachMethod((m1, m2) -> lines.add("MD: " + m1.toString() + " " + m2.toString()));
        return lines;
    }

    public SrgMappings(File file) throws IOException {
        Files.readAllLines(file.toPath()).forEach(line -> {
            Pair<String, String> pair;
            String[] splitted = line.split(" ");
            if (line.startsWith("PK")) {
                this.packages.put(splitted[1], splitted[2]);
            }
            if (line.startsWith("CL")) {
                this.classes.put(splitted[1], splitted[2]);
            }
            if (line.startsWith("FD")) {
                pair = SrgMember.parseMember(splitted[1]);
                Pair<String, String> pair1 = SrgMember.parseMember(splitted[2]);
                this.fields.put(new SrgField((String)pair.getKey(), (String)pair.getValue()), new SrgField((String)pair1.getKey(), (String)pair1.getValue()));
            }
            if (line.startsWith("MD")) {
                pair = SrgMember.parseMember(splitted[1]);
                MethodDescriptor descriptor = new MethodDescriptor((String)pair.getValue(), splitted[2]);
                Pair<String, String> pair1 = SrgMember.parseMember(splitted[3]);
                MethodDescriptor descriptor1 = new MethodDescriptor((String)pair1.getValue(), splitted[4]);
                this.methods.put(new SrgMethod((String)pair.getKey(), (String)pair.getValue(), descriptor.getDescriptor()), new SrgMethod((String)pair.getKey(), (String)pair.getValue(), descriptor1.getDescriptor()));
            }
        });
    }

    public void forEachMethod(BiConsumer<SrgMethod, SrgMethod> consumer) {
        this.methods.forEach(consumer);
    }

    public void forEachField(BiConsumer<SrgField, SrgField> consumer) {
        this.fields.forEach(consumer);
    }

    public void forEachClass(BiConsumer<String, String> consumer) {
        this.classes.forEach(consumer);
    }

    public void forEachPackage(BiConsumer<String, String> consumer) {
        this.packages.forEach(consumer);
    }

    public void remapMethodDescriptors() {
        this.forEachMethod((method, method1) -> {
            ArrayList<NameSpecification> remappedParameters = new ArrayList<NameSpecification>();
            for (NameSpecification nameSpecification : method1.getMethodDescriptor().getArguments()) {
                if (this.classes.containsKey(nameSpecification.jvm())) {
                    remappedParameters.add(new NameSpecification(this.classes.get(nameSpecification.jvm())));
                    continue;
                }
                remappedParameters.add(nameSpecification);
            }
            NameSpecification returnType = method1.getMethodDescriptor().getReturnType();
            if (this.classes.containsKey(returnType.jvm())) {
                returnType = new NameSpecification(this.classes.get(returnType.jvm()));
            }
            NameSpecification[] parameterArray = remappedParameters.toArray(new NameSpecification[remappedParameters.size()]);
            MethodDescriptor newDescriptor = new MethodDescriptor(returnType, parameterArray);
            method1.setMethodDescriptor(newDescriptor);
        });
    }
}

