/*
 * Decompiled with CFR 0.152.
 */
package passion.reflect;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import passion.asm.JvmClass;
import passion.io.env.EnvFile;
import passion.io.env.FileEnvironment;
import sun.misc.IOUtils;

public class Classpath {
    private final ClassLoader classLoader;

    Classpath(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public static Classpath from(ClassLoader classLoader) {
        return new Classpath(classLoader);
    }

    public List<JvmClass> index() throws IOException {
        Enumeration<URL> urlResources = this.classLoader.getResources("");
        ArrayList<JvmClass> classes = new ArrayList<JvmClass>();
        while (urlResources.hasMoreElements()) {
            URL currentElement = urlResources.nextElement();
            if (currentElement == null) continue;
            File file = new File(currentElement.getPath());
            if (file.getName().endsWith(".class")) {
                byte[] bytes = IOUtils.readFully((InputStream)currentElement.openStream(), (int)-1, (boolean)false);
                JvmClass jvmClass = new JvmClass(bytes);
                classes.add(jvmClass);
                continue;
            }
            if (!file.isDirectory() && !file.getName().endsWith(".zip") && !file.getName().endsWith(".jar")) continue;
            FileEnvironment environment = FileEnvironment.construct(file);
            for (EnvFile envFile2 : environment.recursivelyListFiles(envFile -> envFile.getName().endsWith(".class"))) {
                byte[] bytes = IOUtils.readFully((InputStream)envFile2.openStream(), (int)-1, (boolean)false);
                JvmClass jvmClass = new JvmClass(bytes);
                classes.add(jvmClass);
            }
        }
        return classes;
    }
}

