/*
 * Decompiled with CFR 0.152.
 */
package passion.io.env.zip;

import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import passion.io.env.EnvFile;
import passion.io.env.FileEnvironment;
import passion.io.env.nio.PathEnvDirectory;
import passion.io.env.nio.PathEnvFile;

public class ZipFileEnvironment
implements FileEnvironment {
    private final Path path;
    private final FileSystem system;

    public ZipFileEnvironment(Path zipPath) throws IOException {
        this.path = zipPath;
        this.system = FileSystems.newFileSystem(this.path, null);
    }

    private Path getRootPath() {
        Iterator<Path> iterator = this.system.getRootDirectories().iterator();
        if (iterator.hasNext()) {
            Path path = iterator.next();
            return path;
        }
        throw new RuntimeException();
    }

    @Override
    public List<EnvFile> listFiles() {
        ArrayList<EnvFile> envFiles = new ArrayList<EnvFile>();
        try {
            Files.list(this.getRootPath()).forEach(children -> envFiles.add(new PathEnvFile((Path)children)));
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException();
        }
        ArrayList toBeRemoved = new ArrayList();
        ArrayList toBeAdded = new ArrayList();
        envFiles.forEach(envFile -> {
            if (envFile.isDirectory()) {
                toBeRemoved.add(envFile);
                toBeAdded.add(new PathEnvDirectory(((PathEnvFile)envFile).getPath()));
            }
        });
        envFiles.removeAll(toBeRemoved);
        envFiles.addAll(toBeAdded);
        return envFiles;
    }
}

