/*
 * Decompiled with CFR 0.152.
 */
package passion.io.env;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import passion.io.env.EnvFile;
import passion.io.env.file.IoFileEnvironment;
import passion.io.env.zip.ZipFileEnvironment;

public interface FileEnvironment {
    public List<EnvFile> listFiles();

    default public Optional<EnvFile> getFile(String name) {
        for (EnvFile envFile : this.listFiles()) {
            if (!envFile.getName().equals(name)) continue;
            return Optional.of(envFile);
        }
        return Optional.empty();
    }

    public static FileEnvironment construct(File file) {
        if (file.isDirectory()) {
            return new IoFileEnvironment(file);
        }
        if (file.getName().endsWith(".jar") || file.getName().endsWith(".zip")) {
            try {
                return new ZipFileEnvironment(file.toPath());
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new RuntimeException();
            }
        }
        throw new UnsupportedOperationException("Invalid input");
    }

    default public List<EnvFile> listFiles(Predicate<EnvFile> selector) {
        List<EnvFile> envFiles = this.listFiles();
        ArrayList<EnvFile> selected = new ArrayList<EnvFile>();
        envFiles.forEach(envFile -> {
            if (selector.test((EnvFile)envFile)) {
                selected.add((EnvFile)envFile);
            }
        });
        return selected;
    }

    default public List<EnvFile> recursivelyListFiles(Predicate<EnvFile> selector) {
        List<EnvFile> envFiles = this.recursivelyListFiles();
        ArrayList<EnvFile> selected = new ArrayList<EnvFile>();
        envFiles.forEach(envFile -> {
            if (selector.test((EnvFile)envFile)) {
                selected.add((EnvFile)envFile);
            }
        });
        return selected;
    }

    default public List<EnvFile> recursivelyListFiles() {
        ArrayList<EnvFile> files = new ArrayList<EnvFile>();
        this.listFiles().forEach(file -> {
            if (file.isDirectory()) {
                files.addAll(((EnvFile.Directory)file).recursivelyListFiles());
            } else {
                files.add((EnvFile)file);
            }
        });
        return files;
    }
}

