/*
 * Decompiled with CFR 0.152.
 */
package passion.io.env;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public interface EnvFile {
    public String getName();

    public InputStream openStream() throws IOException;

    public boolean isDirectory();

    public static interface Directory
    extends EnvFile {
        public EnvFile[] listFiles();

        default public Optional<EnvFile> getFile(String name) {
            for (EnvFile envFile : this.listFiles()) {
                if (!envFile.getName().equals(name)) continue;
                return Optional.of(envFile);
            }
            return Optional.empty();
        }

        default public List<EnvFile> recursivelyListFiles() {
            ArrayList<EnvFile> envFiles = new ArrayList<EnvFile>();
            for (EnvFile envFile : this.listFiles()) {
                if (envFile.isDirectory()) {
                    Directory directory = (Directory)envFile;
                    envFiles.addAll(directory.recursivelyListFiles());
                    continue;
                }
                envFiles.add(envFile);
            }
            return envFiles;
        }
    }
}

