/*
 * Decompiled with CFR 0.152.
 */
package passion.io;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class FileUtils {
    public static List<File> recursiveSearch(File directory, Predicate<File> filename) throws FileNotFoundException {
        return FileUtils.recursiveSearch(directory).stream().filter(filename).collect(Collectors.toList());
    }

    public static List<File> recursiveSearch(File directory) throws FileNotFoundException {
        if (!directory.exists() || !directory.isDirectory()) {
            throw new FileNotFoundException();
        }
        ArrayList<File> files = new ArrayList<File>();
        File[] listFiles = directory.listFiles();
        if (listFiles == null) {
            throw new FileNotFoundException();
        }
        for (File file : listFiles) {
            if (file.isDirectory()) {
                files.addAll(FileUtils.recursiveSearch(file));
                continue;
            }
            files.add(file);
        }
        return files;
    }
}

