/*
 * Decompiled with CFR 0.152.
 */
package passion.hash;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.xml.bind.DatatypeConverter;
import passion.hash.DigestType;

public class Hasher {
    private final DigestType digestType;
    private final byte[] bytes;

    public Hasher(DigestType type, byte[] bytes) {
        this.digestType = type;
        this.bytes = bytes;
    }

    public Hasher(DigestType type, File file) throws IOException {
        this(type, Files.readAllBytes(file.toPath()));
    }

    public byte[] hash() {
        try {
            MessageDigest digest = MessageDigest.getInstance(this.digestType.toString());
            return digest.digest(this.bytes);
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            throw new RuntimeException("Impossible scene!");
        }
    }

    public String hashHex() {
        return DatatypeConverter.printHexBinary((byte[])this.hash());
    }
}

