/*
 * Decompiled with CFR 0.152.
 */
package passion.asm;

import java.util.List;
import java.util.Optional;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.MethodNode;
import passion.asm.Endpoint;
import passion.asm.InstructionNode;

public class RegularNode
implements InstructionNode {
    private final MethodNode methodNode;
    private final AbstractInsnNode insnNode;

    public RegularNode(MethodNode methodNode, AbstractInsnNode insnNode) {
        this.insnNode = insnNode;
        this.methodNode = methodNode;
    }

    public <T extends AbstractInsnNode> T getHandle() {
        return (T)this.insnNode;
    }

    @Override
    public void insertBefore(List<InstructionNode> instructionNodes) {
        this.methodNode.instructions.insertBefore(this.asm(), Endpoint.from(instructionNodes));
    }

    @Override
    public Optional<InstructionNode> getNext() {
        if (this.insnNode.getNext() != null) {
            return Optional.of(new RegularNode(this.methodNode, this.insnNode.getNext()));
        }
        return Optional.empty();
    }

    @Override
    public Optional<InstructionNode> getPrevious() {
        if (this.insnNode.getPrevious() != null) {
            return Optional.of(new RegularNode(this.methodNode, this.insnNode.getPrevious()));
        }
        return Optional.empty();
    }

    @Override
    public void insertAfter(List<InstructionNode> instructionNodeList) {
        this.methodNode.instructions.insert(this.insnNode, Endpoint.from(instructionNodeList));
    }

    @Override
    public AbstractInsnNode asm() {
        return this.insnNode;
    }
}

