/*
 * Decompiled with CFR 0.152.
 */
package passion.asm;

import org.objectweb.asm.Type;

public class NameSpecification {
    private String className;

    public static NameSpecification fromTypeDescriptor(String desc) {
        return new NameSpecification(Type.getType((String)desc));
    }

    public NameSpecification(String className) {
        if (className == null) {
            throw new RuntimeException("null");
        }
        this.className = className;
        this.transformPrimitives();
    }

    public NameSpecification(Type type) {
        if (type == null || type.getClassName() == null) {
            throw new RuntimeException("null");
        }
        this.className = type.getClassName();
        this.transformPrimitives();
    }

    public String jvm() {
        return this.className.replace('.', '/');
    }

    public String reflect() {
        return this.className.replace('/', '.');
    }

    public String toString() {
        return this.reflect();
    }

    private void transformPrimitives() {
        switch (this.jvm()) {
            case "void": {
                this.className = "V";
                break;
            }
            case "boolean": {
                this.className = "Z";
                break;
            }
            case "double": {
                this.className = "D";
                break;
            }
            case "float": {
                this.className = "F";
                break;
            }
            case "char": {
                this.className = "C";
                break;
            }
            case "long": {
                this.className = "J";
                break;
            }
            case "byte": {
                this.className = "B";
                break;
            }
            case "short": {
                this.className = "S";
                break;
            }
        }
    }
}

