/*
 * Decompiled with CFR 0.152.
 */
package passion.asm;

import java.util.ArrayList;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.Method;
import passion.asm.NameSpecification;

public class MethodDescriptor {
    private final NameSpecification returnType;
    private final NameSpecification[] arguments;

    public MethodDescriptor(NameSpecification returnType, NameSpecification ... arguments) {
        if (returnType == null || arguments == null) {
            throw new RuntimeException("null");
        }
        this.returnType = returnType;
        this.arguments = arguments;
    }

    public NameSpecification getReturnType() {
        return this.returnType;
    }

    public NameSpecification[] getArguments() {
        return this.arguments;
    }

    public MethodDescriptor(String name, String descriptor) {
        if (name == null || descriptor == null) {
            throw new RuntimeException("null");
        }
        Method method = new Method(name, descriptor);
        ArrayList<NameSpecification> arguments = new ArrayList<NameSpecification>();
        for (Type type : method.getArgumentTypes()) {
            arguments.add(new NameSpecification(type));
        }
        this.returnType = new NameSpecification(method.getReturnType());
        this.arguments = arguments.toArray(new NameSpecification[arguments.size()]);
    }

    public String getDescriptor() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('(');
        for (NameSpecification argument : this.arguments) {
            if (argument.jvm().length() == 1) {
                stringBuilder.append(argument.jvm());
                continue;
            }
            stringBuilder.append('L');
            stringBuilder.append(argument.jvm());
            stringBuilder.append(';');
        }
        stringBuilder.append(')');
        if (this.returnType.jvm().length() == 1) {
            stringBuilder.append(this.returnType.jvm());
        } else {
            stringBuilder.append('L');
            stringBuilder.append(this.returnType.jvm());
            stringBuilder.append(';');
        }
        return stringBuilder.toString();
    }
}

