/*
 * Decompiled with CFR 0.152.
 */
package passion.asm;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.List;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.MethodNode;
import passion.asm.BytecodeField;
import passion.asm.BytecodeMethod;
import passion.asm.NameSpecification;

public class JvmClass {
    private final NameSpecification name;
    private final List<BytecodeField> fields = new ArrayList<BytecodeField>();
    private final List<BytecodeMethod> methods = new ArrayList<BytecodeMethod>();
    private final ClassNode handle;

    public ClassNode getHandle() {
        return this.handle;
    }

    public NameSpecification getName() {
        return this.name;
    }

    public List<BytecodeField> getFields() {
        return this.fields;
    }

    public List<BytecodeMethod> getMethods() {
        return this.methods;
    }

    public JvmClass(ClassNode classNode) {
        this.name = new NameSpecification(classNode.name);
        this.handle = classNode;
        classNode.fields.forEach(fieldNode -> this.fields.add(new BytecodeField((FieldNode)fieldNode)));
        classNode.methods.forEach(methodNode -> this.methods.add(new BytecodeMethod((MethodNode)methodNode)));
    }

    private static ClassNode read(byte[] bytes) {
        ClassReader classReader = new ClassReader(bytes);
        ClassNode classNode = new ClassNode();
        classReader.accept((ClassVisitor)classNode, 0);
        return classNode;
    }

    public byte[] toBytes() {
        ClassWriter classWriter = new ClassWriter(0);
        this.handle.accept((ClassVisitor)classWriter);
        return classWriter.toByteArray();
    }

    public void toFile(File file) throws IOException {
        Files.write(file.toPath(), this.toBytes(), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
    }

    public JvmClass(byte[] bytes) {
        this(JvmClass.read(bytes));
    }
}

