/*
 * Decompiled with CFR 0.152.
 */
package passion.asm;

import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import passion.asm.BytecodeMethod;
import passion.asm.MethodDescriptor;
import passion.asm.NameSpecification;
import passion.asm.RegularNode;

public class Invocation
extends RegularNode {
    private final NameSpecification owner;
    private final String name;
    private final MethodDescriptor descriptor;

    public Invocation(MethodNode methodNode, MethodInsnNode insnNode) {
        super(methodNode, (AbstractInsnNode)insnNode);
        this.owner = new NameSpecification(insnNode.owner);
        this.name = insnNode.name;
        this.descriptor = new MethodDescriptor(insnNode.name, insnNode.desc);
        this.setPrime();
    }

    private void setPrime() {
        MethodInsnNode handle = (MethodInsnNode)this.getHandle();
        handle.owner = this.owner.jvm();
        handle.name = this.name;
        handle.desc = this.descriptor.getDescriptor();
    }

    private static MethodInsnNode createMethodInsnNode(int opcode, String owner, String name, String desc) {
        if (owner == null || name == null || desc == null) {
            throw new RuntimeException();
        }
        return new MethodInsnNode(opcode, owner, name, desc);
    }

    public static Invocation invokeStatic(BytecodeMethod bytecodeMethod, String owner, String name, String desc) {
        return new Invocation(bytecodeMethod.asm(), 184, new NameSpecification(owner), name, new MethodDescriptor(bytecodeMethod.asm().name, desc));
    }

    public boolean isStaticInvoke() {
        return this.asm().getOpcode() == 184;
    }

    public Invocation(MethodNode methodNode, int opcode, NameSpecification owner, String name, MethodDescriptor descriptor) {
        super(methodNode, (AbstractInsnNode)Invocation.createMethodInsnNode(opcode, owner.jvm(), name, descriptor.getDescriptor()));
        this.owner = owner;
        this.name = name;
        this.descriptor = descriptor;
        this.setPrime();
    }

    public String getName() {
        return this.name;
    }

    public NameSpecification getOwner() {
        return this.owner;
    }

    public MethodDescriptor getDescriptor() {
        return this.descriptor;
    }
}

