/*
 * Decompiled with CFR 0.152.
 */
package passion.asm;

import java.util.ArrayList;
import java.util.List;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import passion.asm.Endpoint;
import passion.asm.EndpointService;
import passion.asm.InstructionNode;
import passion.asm.Invocation;
import passion.asm.MethodDescriptor;
import passion.asm.RegularNode;

public class BytecodeMethod
implements EndpointService {
    private final MethodNode methodNode;

    public BytecodeMethod(MethodNode methodNode) {
        this.methodNode = methodNode;
    }

    public MethodNode asm() {
        return this.methodNode;
    }

    public List<InstructionNode> instructions() {
        ArrayList<InstructionNode> instructionNodes = new ArrayList<InstructionNode>();
        this.methodNode.instructions.iterator().forEachRemaining(instructionNode -> instructionNodes.add(new RegularNode(this.methodNode, (AbstractInsnNode)instructionNode)));
        return instructionNodes;
    }

    public List<Invocation> getInvocations() {
        ArrayList<Invocation> invocations = new ArrayList<Invocation>();
        this.instructions().forEach(instructionNode -> {
            if (instructionNode.asm() instanceof MethodInsnNode) {
                invocations.add(new Invocation(this.methodNode, (MethodInsnNode)instructionNode.asm()));
            }
        });
        return invocations;
    }

    public MethodDescriptor getDescriptor() {
        return new MethodDescriptor(this.methodNode.name, this.methodNode.desc);
    }

    @Override
    public List<Endpoint> getAllEndpoints() {
        ArrayList<Endpoint> endpoints = new ArrayList<Endpoint>();
        this.instructions().forEach(instructionNode -> {
            if (instructionNode.asm().getOpcode() == 177 || instructionNode.asm().getOpcode() == 172) {
                endpoints.add(new Endpoint(this.methodNode, instructionNode.asm()));
            }
        });
        return endpoints;
    }
}

