/*
 * Decompiled with CFR 0.152.
 */
package online.pizzacrust.graphitemappings.srg;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import online.pizzacrust.graphitemappings.MappingsBase;
import online.pizzacrust.graphitemappings.srg.FieldRef;
import online.pizzacrust.graphitemappings.srg.MethodRef;
import online.pizzacrust.graphitemappings.srg.TypeNameEnforcer;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.Method;

public class Mappings {
    private final Map<String, String> classMappings = new HashMap<String, String>();
    private final Map<FieldRef, FieldRef> fieldMappings = new HashMap<FieldRef, FieldRef>();
    private final Map<MethodRef, MethodRef> methodMappings = new HashMap<MethodRef, MethodRef>();

    public void putClass(String a, String b) {
        this.classMappings.put(new TypeNameEnforcer(a).getJvmStandard(), new TypeNameEnforcer(b).getJvmStandard());
    }

    public static void main(String ... args) throws Exception {
        System.out.println(Type.getObjectType((String)"test/meow").getClassName());
        String descriptor = Type.getMethodDescriptor((Type)Type.getObjectType((String)"test/meow"), (Type[])new Type[0]);
        System.out.println(descriptor);
        System.out.println(Mappings.createDescriptor(new TypeNameEnforcer("boolean"), Collections.emptyList()));
    }

    public Optional<String> getObfuscatedClassName(String remappedName) {
        for (Map.Entry<String, String> entry : this.classMappings.entrySet()) {
            if (!entry.getValue().equals(remappedName)) continue;
            return Optional.of(entry.getKey());
        }
        return Optional.empty();
    }

    private static String transformPrimitive(TypeNameEnforcer typeNameEnforcer) {
        if (typeNameEnforcer.getJvmStandard().equals("boolean")) {
            return "Z";
        }
        return typeNameEnforcer.getJvmStandard();
    }

    public static String createDescriptor(TypeNameEnforcer returnType, List<TypeNameEnforcer> typeNameEnforcers) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('(');
        typeNameEnforcers.forEach(typeNameEnforcer -> {
            if (MappingsBase.isPrimitiveType(typeNameEnforcer.getJvmStandard())) {
                stringBuilder.append(Mappings.transformPrimitive(typeNameEnforcer));
            } else {
                stringBuilder.append('L');
                stringBuilder.append(typeNameEnforcer.getJvmStandard());
                stringBuilder.append(';');
            }
        });
        stringBuilder.append(')');
        if (MappingsBase.isPrimitiveType(returnType.getJvmStandard())) {
            stringBuilder.append(Mappings.transformPrimitive(returnType));
        } else {
            stringBuilder.append('L');
            stringBuilder.append(returnType.getJvmStandard());
            stringBuilder.append(';');
        }
        return stringBuilder.toString();
    }

    public void putMethod(MethodRef a, MethodRef b) {
        Method descriptor = new Method(b.getMethodName(), b.getMethodDesc());
        TypeNameEnforcer returnType = new TypeNameEnforcer(descriptor.getReturnType().getClassName());
        if (this.classMappings.containsKey(returnType.getJvmStandard())) {
            returnType = new TypeNameEnforcer(this.classMappings.get(returnType.getJvmStandard()));
        }
        ArrayList<TypeNameEnforcer> parameterTypes = new ArrayList<TypeNameEnforcer>();
        for (Type type : descriptor.getArgumentTypes()) {
            if (this.classMappings.containsKey(new TypeNameEnforcer(type.getClassName()).getJvmStandard())) {
                parameterTypes.add(new TypeNameEnforcer(this.classMappings.get(new TypeNameEnforcer(type.getClassName()).getJvmStandard())));
                continue;
            }
            parameterTypes.add(new TypeNameEnforcer(type.getClassName()));
        }
        MethodRef newB = new MethodRef(b.getClassName(), b.getMethodName(), Mappings.createDescriptor(returnType, parameterTypes));
        this.methodMappings.put(a, newB);
    }

    public void putField(FieldRef a, FieldRef b) {
        this.fieldMappings.put(a, b);
    }

    public static Mappings chain(List<Mappings> mappingss) {
        Mappings central = new Mappings();
        mappingss.forEach(mappings -> {
            mappings.classMappings.forEach(central::putClass);
            mappings.fieldMappings.forEach(central::putField);
            mappings.methodMappings.forEach(central::putMethod);
        });
        return central;
    }

    public List<String> lines() {
        ArrayList<String> lines = new ArrayList<String>();
        this.classMappings.forEach((a, b) -> lines.add("CL: ".concat((String)a).concat(" ").concat((String)b)));
        this.fieldMappings.forEach((a, b) -> lines.add("FD: ".concat(a.toString()).concat(" ").concat(b.toString())));
        this.methodMappings.forEach((a, b) -> lines.add("MD: ".concat(a.toString()).concat(" ").concat(b.toString())));
        return lines;
    }
}

