/*
 * Decompiled with CFR 0.152.
 */
package online.pizzacrust.graphitemappings.mcs;

import java.util.Optional;
import java.util.jar.JarFile;
import online.pizzacrust.graphitemappings.MappingsBase;
import online.pizzacrust.graphitemappings.TypeMappings;
import online.pizzacrust.graphitemappings.mcs.WorldServerMappings;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.TypeInsnNode;

@TypeMappings(value="net.minecraft.world.World")
public class WorldMappings
extends MappingsBase {
    private final WorldServerMappings worldServerMappings;

    public WorldMappings(JarFile jarFile, WorldServerMappings worldServerMappings) {
        super(jarFile);
        this.worldServerMappings = worldServerMappings;
    }

    @Override
    protected String obfName() {
        Optional<String> mappedName = this.worldServerMappings.getMappings().getObfuscatedClassName(this.getJavaType().getJvmStandard());
        if (mappedName.isPresent()) {
            return mappedName.get();
        }
        throw new RuntimeException();
    }

    @Override
    protected void remap() {
        this.findNode(this.getObfType().getJvmStandard()).ifPresent(classNode -> classNode.methods.forEach(methodNode -> {
            if (methodNode.name.equals("<init>")) {
                methodNode.instructions.iterator().forEachRemaining(insnNode -> {
                    if (insnNode.getOpcode() == 189 && insnNode instanceof TypeInsnNode) {
                        TypeInsnNode typeInsnNode = (TypeInsnNode)insnNode;
                        Type type = Type.getType((String)typeInsnNode.desc);
                        this.getMappings().putClass(type.getInternalName(), "net.minecraft.world.IWorldEventListener");
                    }
                });
            }
        }));
    }
}

