/*
 * Decompiled with CFR 0.152.
 */
package online.pizzacrust.graphitemappings.mcs;

import java.util.List;
import java.util.Optional;
import java.util.jar.JarFile;
import online.pizzacrust.graphitemappings.MappingsBase;
import online.pizzacrust.graphitemappings.TypeMappings;
import online.pizzacrust.graphitemappings.srg.FieldRef;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.Method;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;

@TypeMappings(value="net.minecraft.server.MinecraftServer")
public class MinecraftServerMappings
extends MappingsBase {
    public MinecraftServerMappings(JarFile jarFile) {
        super(jarFile);
    }

    @Override
    protected String obfName() {
        return "net.minecraft.server.MinecraftServer";
    }

    private boolean containsMethod(ClassNode newNode, MethodNode oldNode) {
        for (MethodNode methodNode : newNode.methods) {
            if (!methodNode.name.equals(oldNode.name) || !methodNode.desc.equals(oldNode.desc)) continue;
            return true;
        }
        return false;
    }

    private boolean equalsList(List list, List list1) {
        list.removeAll(list1);
        return list.size() == 0;
    }

    @Override
    protected void remap() {
        Optional<ClassNode> minecraftServer = this.findNode("net.minecraft.server.MinecraftServer");
        if (!minecraftServer.isPresent()) {
            throw new RuntimeException("This is not the server!");
        }
        ClassNode mcs = minecraftServer.get();
        for (FieldNode fieldNode : mcs.fields) {
            String className = Type.getType((String)fieldNode.desc).getClassName();
            if (className.equals("org.apache.logging.log4j.Logger")) {
                this.getMappings().putField(this.createObfFd(fieldNode), this.createRemappedFd("logger"));
            }
            if (!className.replace("[]", "").equals("java.lang.String") && !MinecraftServerMappings.isPrimitiveType(className)) {
                if ((fieldNode.access & 1) == 0 || (fieldNode.access & 0x10) != 0) continue;
                this.getMappings().putField(this.createObfFd(fieldNode), this.createRemappedFd("worlds"));
                this.getMappings().putClass(className.replace("[]", ""), "net.minecraft.world.WorldServer");
                continue;
            }
            if (className.replace("[]", "").equals("java.lang.String") || !MinecraftServerMappings.isPrimitiveType(className) || (fieldNode.access & 1) == 0 || (fieldNode.access & 0x10) != 0 || !className.contains("[][]")) continue;
            this.getMappings().putField(this.createObfFd(fieldNode), this.createRemappedFd("timeOfLastDimensionTick"));
        }
        for (MethodNode methodNode : mcs.methods) {
            Type argument;
            Method descriptor = new Method(methodNode.name, methodNode.desc);
            if (methodNode.name.equals("<clinit>") && descriptor.getArgumentTypes().length == 0) {
                methodNode.instructions.iterator().forEachRemaining(insnNode -> {
                    if (insnNode instanceof LdcInsnNode) {
                        AbstractInsnNode abstractInsnNode;
                        String string;
                        LdcInsnNode ldcInsnNode = (LdcInsnNode)insnNode;
                        if (ldcInsnNode.cst instanceof String && (string = (String)ldcInsnNode.cst).equals("usercache.json") && (abstractInsnNode = insnNode.getNext().getNext()) instanceof FieldInsnNode && abstractInsnNode.getOpcode() == 179) {
                            FieldInsnNode varInsnNode = (FieldInsnNode)abstractInsnNode;
                            this.getMappings().putField(new FieldRef(varInsnNode.owner, varInsnNode.name), this.createRemappedFd("USER_CACHE_FILE"));
                        }
                    }
                });
            }
            if (methodNode.name.equals("main") && descriptor.getArgumentTypes().length >= 1 && (argument = descriptor.getArgumentTypes()[0]).getClassName().equals("java.lang.String[]")) {
                boolean[] mapped = new boolean[]{false};
                methodNode.instructions.iterator().forEachRemaining(insnNode -> {
                    Method insnMethod;
                    MethodInsnNode methodInsnNode;
                    if (insnNode instanceof MethodInsnNode && (methodInsnNode = (MethodInsnNode)insnNode).getOpcode() == 182 && (insnMethod = new Method(methodInsnNode.name, methodInsnNode.desc)).getArgumentTypes().length == 0 && insnMethod.getReturnType().equals((Object)Type.VOID_TYPE) && !mapped[0]) {
                        this.getMappings().putClass(methodInsnNode.owner, "net.minecraft.server.dedicated.DedicatedServer");
                        mapped[0] = true;
                    }
                });
            }
            if (!descriptor.getReturnType().getClassName().equals("java.lang.String")) continue;
            methodNode.instructions.iterator().forEachRemaining(instruction -> {
                if (instruction instanceof LdcInsnNode) {
                    String constant;
                    LdcInsnNode ldcInsnNode = (LdcInsnNode)instruction;
                    if (ldcInsnNode.cst instanceof String && !(constant = (String)ldcInsnNode.cst).equals("vanilla")) {
                        if (constant.equals("Server")) {
                            this.getMappings().putMethod(this.createObfMd(methodNode), this.createRemappedMd("getName", methodNode));
                            this.interfacesOf(mcs).forEach(parentInterface -> {
                                if (this.containsMethod((ClassNode)parentInterface, methodNode)) {
                                    this.getMappings().putClass(parentInterface.name, "net.minecraft.server.command.ICommandSender");
                                }
                            });
                        } else {
                            this.getMappings().putMethod(this.createObfMd(methodNode), this.createRemappedMd("getMinecraftVersion", methodNode));
                        }
                    }
                }
            });
        }
    }
}

