/*
 * Decompiled with CFR 0.152.
 */
package online.pizzacrust.graphitemappings.mcs;

import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.jar.JarFile;
import online.pizzacrust.graphitemappings.MappingsBase;
import online.pizzacrust.graphitemappings.TypeMappings;
import online.pizzacrust.graphitemappings.mcs.MinecraftServerMappings;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;

@TypeMappings(value="net.minecraft.server.dedicated.DedicatedServer")
public class DedicatedServerMappings
extends MappingsBase {
    private final MinecraftServerMappings minecraftServerMappings;

    public DedicatedServerMappings(JarFile jarFile, MinecraftServerMappings minecraftServerMappings) {
        super(jarFile);
        this.minecraftServerMappings = minecraftServerMappings;
    }

    @Override
    protected String obfName() {
        Optional<String> dedicatedServerOpt = this.minecraftServerMappings.getMappings().getObfuscatedClassName(this.getJavaType().getJvmStandard());
        if (dedicatedServerOpt.isPresent()) {
            return dedicatedServerOpt.get();
        }
        throw new RuntimeException();
    }

    @Override
    protected void remap() {
        this.findNode(this.getObfType().getJvmStandard()).ifPresent(classNode -> {
            List<ClassNode> interfaces = this.interfacesOf((ClassNode)classNode);
            if (interfaces.size() == 1) {
                boolean[] already = new boolean[]{false};
                interfaces.forEach(interfaceNode -> {
                    if (!already[0]) {
                        this.getMappings().putClass(interfaceNode.name, "net.minecraft.network.rcon.IServer");
                        already[0] = true;
                    }
                });
            }
            for (MethodNode methodNode : classNode.methods) {
                AtomicBoolean captureNextNew = new AtomicBoolean(false);
                methodNode.instructions.iterator().forEachRemaining(insnNode -> {
                    TypeInsnNode typeInsnNode;
                    if (insnNode instanceof TypeInsnNode && (typeInsnNode = (TypeInsnNode)insnNode).getOpcode() == 187 && captureNextNew.get()) {
                        this.getMappings().putClass(Type.getType((String)typeInsnNode.desc).getInternalName(), "net.minecraft.server.dedicated.PropertyManager");
                        captureNextNew.set(false);
                    }
                    if (insnNode instanceof LdcInsnNode) {
                        LdcInsnNode ldcInsnNode = (LdcInsnNode)insnNode;
                        if (ldcInsnNode.cst instanceof String) {
                            MethodInsnNode methodInsnNode;
                            AbstractInsnNode abstractInsnNode;
                            String cst = (String)ldcInsnNode.cst;
                            if (cst.equals("Server console handler")) {
                                this.getMappings().putMethod(this.createObfMd(methodNode), this.createRemappedMd("init", methodNode));
                            }
                            if (cst.equals("Loading properties")) {
                                captureNextNew.set(true);
                            }
                            if (cst.equals("eula.txt") && (abstractInsnNode = insnNode.getNext().getNext()) instanceof MethodInsnNode && (methodInsnNode = (MethodInsnNode)abstractInsnNode).getOpcode() == 183) {
                                this.getMappings().putClass(methodInsnNode.owner, "net.minecraft.server.ServerEula");
                            }
                        }
                    }
                });
            }
        });
    }
}

