/*
 * Decompiled with CFR 0.152.
 */
package online.pizzacrust.graphitemappings;

import java.beans.ConstructorProperties;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Optional;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import online.pizzacrust.graphitemappings.TypeMappings;
import online.pizzacrust.graphitemappings.srg.FieldRef;
import online.pizzacrust.graphitemappings.srg.Mappings;
import online.pizzacrust.graphitemappings.srg.MethodRef;
import online.pizzacrust.graphitemappings.srg.TypeNameEnforcer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.MethodNode;
import sun.misc.IOUtils;

public abstract class MappingsBase {
    public static final String[] PRIMITIVE_TYPES = new String[]{"long", "float", "int", "double", "byte", "boolean"};
    private final Mappings mappings = new Mappings();
    private final JarFile jarFile;

    public static boolean isPrimitiveType(String string) {
        for (String primitiveType : PRIMITIVE_TYPES) {
            if (!string.contains(primitiveType)) continue;
            return true;
        }
        return false;
    }

    public Mappings getMappings() {
        return this.mappings;
    }

    protected abstract String obfName();

    protected abstract void remap();

    protected List<ClassNode> interfacesOf(ClassNode node) {
        ArrayList<ClassNode> classNodes = new ArrayList<ClassNode>();
        node.interfaces.forEach(interfaceName -> this.findNode((String)interfaceName).ifPresent(classNodes::add));
        return classNodes;
    }

    protected MethodRef createObfMd(MethodNode methodNode) {
        return new MethodRef(this.getObfType().getJvmStandard(), methodNode.name, methodNode.desc);
    }

    protected MethodRef createRemappedMd(String renamed, MethodNode obf) {
        return new MethodRef(this.getJavaType().getJvmStandard(), renamed, obf.desc);
    }

    protected FieldRef createObfFd(FieldNode fieldNode) {
        return new FieldRef(this.getObfType().getJvmStandard(), fieldNode.name);
    }

    protected FieldRef createRemappedFd(String renamed) {
        return new FieldRef(this.getJavaType().getJvmStandard(), renamed);
    }

    public static Mappings chainClasses(List<MappingsBase> mappingsBases) {
        ArrayList<Mappings> mutableMappingss = new ArrayList<Mappings>();
        Mappings classMappings = new Mappings();
        mutableMappingss.add(classMappings);
        mappingsBases.forEach(mappingsBase -> {
            classMappings.putClass(mappingsBase.getObfType().getJvmStandard(), mappingsBase.getJavaType().getJvmStandard());
            mappingsBase.remap();
            mutableMappingss.add(mappingsBase.getMappings());
        });
        return Mappings.chain(mutableMappingss);
    }

    public TypeNameEnforcer getJavaType() {
        return new TypeNameEnforcer(this.getRemappedJvmName());
    }

    public TypeNameEnforcer getObfType() {
        return new TypeNameEnforcer(this.obfName());
    }

    public static void writeClasses(List<MappingsBase> mappingsBases, File file) throws IOException {
        List<String> lines = MappingsBase.chainClasses(mappingsBases).lines();
        Files.write(file.toPath(), lines, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.CREATE);
    }

    public String getRemappedReflectName() {
        if (this.getClass().isAnnotationPresent(TypeMappings.class)) {
            return this.getClass().getAnnotation(TypeMappings.class).value();
        }
        throw new RuntimeException("No annotation present!");
    }

    public String getRemappedJvmName() {
        return this.getRemappedReflectName().replace('.', '/');
    }

    private List<ClassNode> indexJar() {
        ArrayList<ClassNode> classNodes = new ArrayList<ClassNode>();
        Enumeration<JarEntry> enumeration = this.jarFile.entries();
        while (enumeration.hasMoreElements()) {
            JarEntry jarEntry = enumeration.nextElement();
            if (jarEntry == null || !jarEntry.getName().endsWith(".class")) continue;
            try {
                byte[] classBytes = IOUtils.readFully((InputStream)this.jarFile.getInputStream(jarEntry), (int)-1, (boolean)false);
                ClassReader classReader = new ClassReader(classBytes);
                ClassNode classNode = new ClassNode();
                classReader.accept((ClassVisitor)classNode, 0);
                classNodes.add(classNode);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return classNodes;
    }

    public Optional<ClassNode> findNode(String reflectName) {
        String jvmName = reflectName.replace('.', '/');
        for (ClassNode classNode : this.indexJar()) {
            if (!classNode.name.equals(jvmName)) continue;
            return Optional.of(classNode);
        }
        return Optional.empty();
    }

    @ConstructorProperties(value={"jarFile"})
    public MappingsBase(JarFile jarFile) {
        this.jarFile = jarFile;
    }
}

