package online.osslab.AboutPage;

import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Build;
import android.support.graphics.drawable.VectorDrawableCompat;
import android.support.v4.content.ContextCompat;
import android.support.v4.graphics.drawable.DrawableCompat;
import android.support.v4.widget.TextViewCompat;
import android.text.TextUtils;
import android.util.TypedValue;
import android.view.Gravity;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;

import java.util.Calendar;

import online.osslab.libary.R;

/**
 * Code is Poetry.
 * =================================================
 * Author ：Wall·E
 * Version：v1.1.1.1
 * =================================================
 * http://osslab.online/
 */

public class AboutPage {
    private final Context context;
    private final LayoutInflater inflater;
    private final View view;
    private String developer;
    private int copyrightFrom = 0;
    private boolean isRTL = false;
    private Typeface customFont;

    public AboutPage(Context context) {
        this.context = context;
        this.inflater = LayoutInflater.from(context);
        this.view = inflater.inflate(R.layout.about_page, null);
    }

    public AboutPage setCustomFont(String path) {
        customFont = Typeface.createFromAsset(context.getAssets(), path);
        return this;
    }

    /*
        Add Email Element
     */
    public AboutPage addEmail(String email) {
        Element emailElement = new Element();
        emailElement.setTitle(context.getString(R.string.about_contact));
        emailElement.setIcon(R.drawable.about_icon_email);
        emailElement.setColor(ContextCompat.getColor(context, R.color.about_item_icon_color));

        Intent intent = new Intent(Intent.ACTION_SEND);
        intent.setType("message/rfc822");
        intent.putExtra(Intent.EXTRA_EMAIL, new String[]{email});
        emailElement.setIntent(intent);

        addItem(emailElement);
        return this;
    }

    /*
        Add Facebook Element
     */
    public AboutPage addFacebook(String id) {
        Element facebookElement = new Element();
        facebookElement.setTitle(context.getString(R.string.about_facebook));
        facebookElement.setIcon(R.drawable.about_icon_facebook);
        facebookElement.setColor(ContextCompat.getColor(context, R.color.about_facebook_color));
        facebookElement.setValue(id);

        Intent intent = new Intent();
        intent.setAction(Intent.ACTION_VIEW);
        intent.addCategory(Intent.CATEGORY_BROWSABLE);

        if (AboutPageUtils.isAppInstalled(context, "com.facebook.katana")) {
            intent.setPackage("com.facebook.katana");
            int versionCode = 0;
            try {
                versionCode = context.getPackageManager().getPackageInfo("com.facebook.katana", 0).versionCode;
            } catch (PackageManager.NameNotFoundException e) {
                e.printStackTrace();
            }

            if (versionCode >= 3002850) {
                Uri uri = Uri.parse("fb://facewebmodal/f?href=" + "http://m.facebook.com/" + id);
                intent.setData(uri);
            } else {
                Uri uri = Uri.parse("fb://page/" + id);
                intent.setData(uri);
            }
        } else {
            intent.setData(Uri.parse("http://m.facebook.com/" + id));
        }

        facebookElement.setIntent(intent);

        addItem(facebookElement);
        return this;
    }


    /*
        Add Twitter Element
     */
    public AboutPage addTwitter(String id) {
        Element twitterElement = new Element();
        twitterElement.setTitle(context.getString(R.string.about_twitter));
        twitterElement.setIcon(R.drawable.about_icon_twitter);
        twitterElement.setColor(ContextCompat.getColor(context, R.color.about_twitter_color));
        twitterElement.setValue(id);

        Intent intent = new Intent();
        intent.setAction(Intent.ACTION_VIEW);
        intent.addCategory(Intent.CATEGORY_BROWSABLE);

        if (AboutPageUtils.isAppInstalled(context, "com.twitter.android")) {
            intent.setPackage("com.twitter.android");
            intent.setData(Uri.parse(String.format("twitter://user?screen_name=%s", id)));
        } else {
            intent.setData(Uri.parse(String.format("http://twitter.com/intent/user?screen_name=%s", id)));
        }

        twitterElement.setIntent(intent);
        addItem(twitterElement);
        return this;
    }

    /*
        Add Play store Element
     */
    public AboutPage addPlayStore(String id) {
        Element playStoreElement = new Element();
        playStoreElement.setTitle(context.getString(R.string.about_play_store));
        playStoreElement.setIcon(R.drawable.about_icon_google_play);
        playStoreElement.setColor(ContextCompat.getColor(context, R.color.about_play_store_color));
        playStoreElement.setValue(id);

        Uri uri = Uri.parse("market://details?id=" + id);
        Intent goToMarket = new Intent(Intent.ACTION_VIEW, uri);
        playStoreElement.setIntent(goToMarket);

        addItem(playStoreElement);
        return this;
    }

    /*
        Add Youtube Element
     */
    public AboutPage addYoutube(String id) {
        Element youtubeElement = new Element();
        youtubeElement.setTitle(context.getString(R.string.about_youtube));
        youtubeElement.setIcon(R.drawable.about_icon_youtube);
        youtubeElement.setColor(ContextCompat.getColor(context, R.color.about_youtube_color));
        youtubeElement.setValue(id);

        Intent intent = new Intent();
        intent.setAction(Intent.ACTION_VIEW);
        intent.setData(Uri.parse(String.format("http://youtube.com/channel/%s", id)));

        if (AboutPageUtils.isAppInstalled(context, "com.google.android.youtube")) {
            intent.setPackage("com.google.android.youtube");
        }

        youtubeElement.setIntent(intent);
        addItem(youtubeElement);

        return this;
    }

    /*
        Add Instagram Element
     */
    public AboutPage addInstagram(String id) {
        Element instagramElement = new Element();
        instagramElement.setTitle(context.getString(R.string.about_instagram));
        instagramElement.setIcon(R.drawable.about_icon_instagram);
        instagramElement.setColor(ContextCompat.getColor(context, R.color.about_instagram_color));
        instagramElement.setValue(id);

        Intent intent = new Intent();
        intent.setAction(Intent.ACTION_VIEW);
        intent.setData(Uri.parse("http://instagram.com/_u/" + id));

        if (AboutPageUtils.isAppInstalled(context, "com.instagram.android")) {
            intent.setPackage("com.instagram.android");
        }

        instagramElement.setIntent(intent);
        addItem(instagramElement);

        return this;
    }

    /*
        Add GitHub Element
    */
    public AboutPage addGitHub(String id) {
        Element gitHubElement = new Element();
        gitHubElement.setTitle(context.getString(R.string.about_github));
        gitHubElement.setIcon(R.drawable.about_icon_github);
        gitHubElement.setColor(ContextCompat.getColor(context, R.color.about_github_color));
        gitHubElement.setValue(id);

        Intent intent = new Intent();
        intent.setAction(Intent.ACTION_VIEW);
        intent.addCategory(Intent.CATEGORY_BROWSABLE);
        intent.setData(Uri.parse(String.format("https://github.com/%s", id)));

        gitHubElement.setIntent(intent);
        addItem(gitHubElement);

        return this;
    }

    /*
        Add Website Element
    */
    public AboutPage addWebsite(String url) {
        if (!url.startsWith("http://") && !url.startsWith("https://")) {
            url = "http://" + url;
        }
        Element websiteElement = new Element();
        websiteElement.setTitle(context.getString(R.string.about_website));
        websiteElement.setIcon(R.drawable.about_icon_link);
        websiteElement.setColor(ContextCompat.getColor(context, R.color.about_item_icon_color));
        websiteElement.setValue(url);

        Uri uri = Uri.parse(url);
        Intent browserIntent = new Intent(Intent.ACTION_VIEW, uri);

        websiteElement.setIntent(browserIntent);
        addItem(websiteElement);

        return this;
    }

    public AboutPage addItem(Element element) {
        LinearLayout providers = (LinearLayout) view.findViewById(R.id.providers);
        providers.addView(createItem(element));
        providers.addView(getSeparator(), new ViewGroup.LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, context.getResources().getDimensionPixelSize(R.dimen.about_separator_height)));
        return this;
    }

    public AboutPage addGroup(String name) {

        TextView textView = new TextView(context);
        textView.setText(name);
        TextViewCompat.setTextAppearance(textView, R.style.AboutPageStyle_GroupTextAppearance);
        LinearLayout.LayoutParams textParams = new LinearLayout.LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.WRAP_CONTENT);

        if (customFont != null) {
            textView.setTypeface(customFont);
        }

        int padding = context.getResources().getDimensionPixelSize(R.dimen.about_group_text_padding);
        textView.setPadding(padding, padding, padding, padding);


        if (isRTL) {
            textView.setGravity(Gravity.END | Gravity.CENTER_VERTICAL);
            textParams.gravity = Gravity.END | Gravity.CENTER_VERTICAL;
        } else {
            textView.setGravity(Gravity.START | Gravity.CENTER_VERTICAL);
            textParams.gravity = Gravity.START | Gravity.CENTER_VERTICAL;
        }

        textView.setBackgroundColor(context.getResources().getColor(R.color.about_background_color));
        textView.setLayoutParams(textParams);

        ((LinearLayout) view.findViewById(R.id.providers)).addView(textView);
        return this;
    }

    public AboutPage isRTL(boolean isRTL) {
        this.isRTL = isRTL;
        return this;
    }

    public AboutPage setDeveloper(String developer) {
        this.developer = developer;
        return this;
    }

    public AboutPage setCopyrightFrom(int from) {
        this.copyrightFrom = from;
        return this;
    }

    public View create(Context context) {
        ImageView icon = (ImageView) view.findViewById(R.id.icon);
        TextView label = (TextView) view.findViewById(R.id.label);
        TextView versionName = (TextView) view.findViewById(R.id.versionName);
        TextView versionCode = (TextView) view.findViewById(R.id.versionCode);

        TextView developer = (TextView) view.findViewById(R.id.developer);
        TextView copyright = (TextView) view.findViewById(R.id.copyright);

        icon.setImageDrawable(context.getPackageManager().getApplicationIcon(context.getApplicationInfo()));
        label.setText(context.getPackageManager().getApplicationLabel(context.getApplicationInfo()));
        label.setGravity(Gravity.CENTER);

        try {
            versionName.setText("Version " + context.getPackageManager().getPackageInfo(context.getPackageName(),
                    0).versionName);
            versionCode.setText("Build " + context.getPackageManager().getPackageInfo(context.getPackageName(),
                    0).versionCode);
        } catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }

        if (!TextUtils.isEmpty(this.developer)) {
            developer.setText(this.developer);
        }

        if (this.copyrightFrom > 0) {
            copyright.setText(String.format(this.context.getString(R.string.about_copyright_from_to), this.copyrightFrom, Calendar.getInstance().get(java.util.Calendar.YEAR)));
        } else {
            copyright.setText(String.format(this.context.getString(R.string.about_copyright), Calendar.getInstance().get(Calendar.YEAR)));
        }

        return view;
    }

    private View createItem(final Element element) {
        LinearLayout wrapper = new LinearLayout(context);
        wrapper.setOrientation(LinearLayout.HORIZONTAL);
        wrapper.setClickable(true);

        if (element.getOnClickListener() != null) {
            wrapper.setOnClickListener(element.getOnClickListener());
        } else if (element.getIntent() != null) {
            wrapper.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View view) {
                    try {
                        context.startActivity(element.getIntent());
                    } catch (Exception e) {
                    }
                }
            });

        }

        TypedValue outValue = new TypedValue();
        context.getTheme().resolveAttribute(R.attr.selectableItemBackground, outValue, true);
        wrapper.setBackgroundResource(outValue.resourceId);

        int padding = context.getResources().getDimensionPixelSize(R.dimen.about_text_padding);
        wrapper.setPadding(padding, padding, padding, padding);
        LinearLayout.LayoutParams wrapperParams = new LinearLayout.LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.WRAP_CONTENT);
        wrapper.setLayoutParams(wrapperParams);


        TextView textView = new TextView(context);
        TextViewCompat.setTextAppearance(textView, R.style.AboutPageStyle_ElementTextAppearance);
        LinearLayout.LayoutParams textParams = new LinearLayout.LayoutParams(ViewGroup.LayoutParams.WRAP_CONTENT, ViewGroup.LayoutParams.WRAP_CONTENT);
        textView.setLayoutParams(textParams);
        if (customFont != null) {
            textView.setTypeface(customFont);
        }

        ImageView iconView = null;

        if (element.getIcon() != null) {
            iconView = new ImageView(context);
            int size = context.getResources().getDimensionPixelSize(R.dimen.about_icon_size);
            LinearLayout.LayoutParams iconParams = new LinearLayout.LayoutParams(size, size);
            iconView.setLayoutParams(iconParams);
            int iconPadding = context.getResources().getDimensionPixelSize(R.dimen.about_icon_padding);
            iconView.setPadding(iconPadding, 0, iconPadding, 0);

            if (Build.VERSION.SDK_INT < 21) {
                Drawable drawable = VectorDrawableCompat.create(iconView.getResources(), element.getIcon(), iconView.getContext().getTheme());
                iconView.setImageDrawable(drawable);
            } else {
                iconView.setImageResource(element.getIcon());
            }

            Drawable wrappedDrawable = DrawableCompat.wrap(iconView.getDrawable());
            wrappedDrawable = wrappedDrawable.mutate();
            if (element.getAutoIconColor()) {
                if (element.getColor() != null) {
                    DrawableCompat.setTint(wrappedDrawable, element.getColor());
                } else {
                    DrawableCompat.setTint(wrappedDrawable, ContextCompat.getColor(context, R.color.about_item_icon_color));
                }
            }

        } else {
            int iconPadding = context.getResources().getDimensionPixelSize(R.dimen.about_icon_padding);
            textView.setPadding(iconPadding, iconPadding, iconPadding, iconPadding);
        }


        textView.setText(element.getTitle());


        if (isRTL) {

            final int gravity = element.getGravity() != null ? element.getGravity() : Gravity.END;

            wrapper.setGravity(gravity | Gravity.CENTER_VERTICAL);
            //noinspection ResourceType
            textParams.gravity = gravity | Gravity.CENTER_VERTICAL;
            wrapper.addView(textView);
            if (element.getIcon() != null) {
                wrapper.addView(iconView);
            }

        } else {
            final int gravity = element.getGravity() != null ? element.getGravity() : Gravity.START;
            wrapper.setGravity(gravity | Gravity.CENTER_VERTICAL);
            //noinspection ResourceType
            textParams.gravity = gravity | Gravity.CENTER_VERTICAL;
            if (element.getIcon() != null) {
                wrapper.addView(iconView);
            }
            wrapper.addView(textView);
        }

        return wrapper;
    }

    private View getSeparator() {
        return inflater.inflate(R.layout.about_page_separator, null);
    }
}
