/*
 * Decompiled with CFR 0.152.
 */
package online.inote.naruto.utils;

import com.alibaba.fastjson.JSON;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import online.inote.naruto.utils.Assert;
import online.inote.naruto.utils.StringUtils;
import org.springframework.util.DigestUtils;

public class MdFiveUtils {
    private static final String SALT = DigestUtils.md5DigestAsHex((byte[])"NARUTO-SECURITY".getBytes(StandardCharsets.UTF_8));
    private static final String EMPTY_JSON = "{}";

    public static String encrypt(String data) {
        return DigestUtils.md5DigestAsHex((byte[])(SALT + data).getBytes(StandardCharsets.UTF_8));
    }

    public static String digest(String nonce, String url, Long timestamp, String token, String params, Object ... pathParamsAndRequestBody) {
        Assert.notBlank(nonce, "nonce\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notBlank(url, "url\u4e0d\u80fd\u4e3a\u7a7a");
        StringBuilder sb = new StringBuilder(SALT + nonce + url);
        if (!Objects.isNull(timestamp)) {
            sb.append(timestamp);
        }
        if (!Objects.isNull(token)) {
            sb.append(token);
        }
        if (StringUtils.isNotBlank((CharSequence)params) && !StringUtils.equals((CharSequence)params, (CharSequence)EMPTY_JSON)) {
            sb.append(params);
        }
        sb.append(MdFiveUtils.pathParamsAndRequestBody(pathParamsAndRequestBody));
        return DigestUtils.md5DigestAsHex((byte[])sb.toString().getBytes(StandardCharsets.UTF_8));
    }

    private static String pathParamsAndRequestBody(Object ... pathParamsAndRequestBody) {
        if (pathParamsAndRequestBody != null && pathParamsAndRequestBody.length > 0) {
            List list = Arrays.stream(pathParamsAndRequestBody).sorted(Comparator.comparing(Object::hashCode)).collect(Collectors.toList());
            return JSON.toJSONString(list);
        }
        return "";
    }
}

