package online.inote.naruto.utils;

import com.alibaba.fastjson.JSON;
import org.springframework.util.DigestUtils;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

/**
 * @description MD5工具类(密码加密)
 * @author XQF.Sui
 * @date 2021/08/14 15:59
 */
public class MdFiveUtils {

  private static final String SALT =
      DigestUtils.md5DigestAsHex("NARUTO-SECURITY".getBytes(StandardCharsets.UTF_8));
  private static final String EMPTY_JSON = "{}";

  public static String encrypt(String data) {
    return DigestUtils.md5DigestAsHex((SALT + data).getBytes(StandardCharsets.UTF_8));
  }

  public static String digest(
      final String nonce,
      final String url,
      final Long timestamp,
      final String token,
      final String params,
      final Object... pathParamsAndRequestBody) {

    Assert.notBlank(nonce, "nonce不能为空");
    Assert.notBlank(url, "url不能为空");

    StringBuilder sb = new StringBuilder(SALT + nonce + url);

    if (!Objects.isNull(timestamp)) {
      sb.append(timestamp);
    }

    if (!Objects.isNull(token)) {
      sb.append(token);
    }

    if (StringUtils.isNotBlank(params) && !StringUtils.equals(params, EMPTY_JSON)) {
      sb.append(params);
    }

    sb.append(pathParamsAndRequestBody(pathParamsAndRequestBody));

    return DigestUtils.md5DigestAsHex(sb.toString().getBytes(StandardCharsets.UTF_8));
  }

  private static String pathParamsAndRequestBody(final Object... pathParamsAndRequestBody) {
    if (pathParamsAndRequestBody != null && pathParamsAndRequestBody.length > 0) {
      List<Object> list =
          Arrays.stream(pathParamsAndRequestBody)
              .sorted(Comparator.comparing(Object::hashCode))
              .collect(Collectors.toList());
      return JSON.toJSONString(list);
    }

    return "";
  }
}
