/*
 * Decompiled with CFR 0.152.
 */
package online.inote.naruto.cache;

import java.util.Set;
import java.util.concurrent.TimeUnit;
import online.inote.naruto.cache.CacheManager;
import online.inote.naruto.utils.spring.BeanFactory;

public final class CacheSupport {
    private static final CacheManager CACHE_MANAGER = (CacheManager)BeanFactory.getBean(CacheManager.class);

    public static void cache(String key, String value) {
        CACHE_MANAGER.cache(key, value);
    }

    public static void cache(String key, long ttl) {
        CACHE_MANAGER.cache(key, ttl);
    }

    public static void cache(String key, String value, long ttl) {
        CACHE_MANAGER.cache(key, value, ttl);
    }

    public static Long increment(String key) {
        return CACHE_MANAGER.increment(key);
    }

    public static boolean isExist(String key) {
        return CACHE_MANAGER.isExist(key);
    }

    public static void delete(String key) {
        CACHE_MANAGER.delete(key);
    }

    public static String get(String key) {
        return CACHE_MANAGER.get(key);
    }

    public static Boolean expire(String key, long ttl) {
        return CACHE_MANAGER.expire(key, ttl);
    }

    public static Boolean expire(String key, long ttl, TimeUnit timeUnit) {
        return CACHE_MANAGER.expire(key, ttl, timeUnit);
    }

    public static Long addSet(String key, String ... values) {
        return CACHE_MANAGER.addSet(key, values);
    }

    public static Long addSet(String key, Set<String> set) {
        return CACHE_MANAGER.addSet(key, set.toArray(new String[0]));
    }

    public static Long remove(String key, String ... values) {
        return CACHE_MANAGER.remove(key, values);
    }

    public static Boolean move(String key, String value, String destKey) {
        return CACHE_MANAGER.move(key, value, destKey);
    }

    public static Set<String> members(String key) {
        return CACHE_MANAGER.members(key);
    }

    public static Boolean isMember(String key, String value) {
        return CACHE_MANAGER.isMember(key, value);
    }

    public static Long count(String key) {
        return CACHE_MANAGER.count(key);
    }
}

