/*
 * Decompiled with CFR 0.152.
 */
package online.inote.naruto.api.access.validator;

import io.jsonwebtoken.Claims;
import io.jsonwebtoken.ExpiredJwtException;
import io.jsonwebtoken.IncorrectClaimException;
import io.jsonwebtoken.Jws;
import io.jsonwebtoken.MalformedJwtException;
import java.util.Date;
import java.util.Objects;
import online.inote.naruto.api.access.jwt.JwtHelper;
import online.inote.naruto.api.access.props.ApiAccessProperties;
import online.inote.naruto.cache.CacheSupport;
import online.inote.naruto.exception.token.TokenException;
import online.inote.naruto.utils.Assert;
import online.inote.naruto.utils.DateTimeUtils;
import online.inote.naruto.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApiAccessValidator {
    private static final Logger logger = LoggerFactory.getLogger(ApiAccessValidator.class);

    public static ApiAccessValidatorWorker builder() {
        return new ApiAccessValidatorWorker();
    }

    public static class ApiAccessValidatorWorker {
        private String token;
        private String method;

        public ApiAccessValidatorWorker token(String token) {
            Assert.notBlank((String)token, (String)"Token\u4e0d\u80fd\u4e3a\u7a7a");
            this.token = token;
            return this;
        }

        public ApiAccessValidatorWorker method(String method) {
            Assert.notBlank((String)method, (String)"method\u4e0d\u80fd\u4e3a\u7a7a");
            this.method = method;
            return this;
        }

        public void execute() {
            Jws<Claims> jws = JwtHelper.getClaims(this.token);
            Claims claims = (Claims)jws.getBody();
            if (StringUtils.isBlank((CharSequence)claims.getIssuer()) || Objects.isNull(claims.getIssuedAt())) {
                throw new MalformedJwtException("Token\u89e3\u6790\u5931\u8d25");
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Token\u53d1\u884c\u8005\u4e3a:[ {} ], \u4e8e[ {} ]\u751f\u6210, \u6388\u6743\u7ed9[ {} ]", new Object[]{claims.getIssuer(), DateTimeUtils.format((Date)claims.getIssuedAt()), claims.getAudience()});
            }
            this.isExpired(jws);
            if (ApiAccessProperties.props().getCache().getEnable().booleanValue()) {
                this.isForgery(jws);
                this.isPermission(jws);
            }
        }

        private void isPermission(Jws<Claims> jws) {
            if (!CacheSupport.isMember((String)this.getSystemAuthInterfaceKey((Claims)jws.getBody()), (String)this.method).booleanValue()) {
                throw new TokenException("\u65e0\u6743\u8bbf\u95ee");
            }
        }

        private void isExpired(Jws<Claims> jws) {
            boolean result;
            Claims claims = (Claims)jws.getBody();
            Date expiration = claims.getExpiration();
            if (Objects.nonNull(expiration) && expiration.before(DateTimeUtils.getNow())) {
                throw new ExpiredJwtException(jws.getHeader(), claims, "Token\u5df2\u8fc7\u671f(\u7b7e\u7f72)");
            }
            if (ApiAccessProperties.props().getCache().getEnable().booleanValue() && !(result = CacheSupport.isExist((String)this.getTokenKey(claims)))) {
                throw new ExpiredJwtException(jws.getHeader(), claims, "Token\u5df2\u8fc7\u671f(\u7f13\u5b58)");
            }
        }

        private void isForgery(Jws<Claims> jws) {
            if (!StringUtils.equals((CharSequence)this.token, (CharSequence)CacheSupport.get((String)this.getTokenKey((Claims)jws.getBody())))) {
                throw new IncorrectClaimException(jws.getHeader(), (Claims)jws.getBody(), "\u4f2a\u9020\u7684Token\u4fe1\u606f");
            }
        }

        private String getTokenKey(Claims claims) {
            return this.cacheProps().initSystemTokenCacheKey(claims.getId());
        }

        private String getSystemAuthInterfaceKey(Claims claims) {
            return this.cacheProps().initSystemAuthInterfacePathCacheKey(claims.getId());
        }

        private ApiAccessProperties.Cache cacheProps() {
            return ApiAccessProperties.props().getCache();
        }
    }
}

