/*
 * Decompiled with CFR 0.152.
 */
package online.inote.naruto.api.access.jwt;

import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Jws;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import java.security.Key;
import java.util.Date;
import java.util.Map;
import javax.crypto.spec.SecretKeySpec;
import online.inote.naruto.api.access.props.ApiAccessProperties;
import online.inote.naruto.utils.DateTimeUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class JwtHelper {
    private static final Logger log = LogManager.getLogger(JwtHelper.class);

    public static String genToken(Map<String, Object> claimMap) {
        return Jwts.builder().addClaims(claimMap).setIssuer(ApiAccessProperties.props().getToken().getIssuer()).setIssuedAt(DateTimeUtils.getNow()).signWith(SignatureAlgorithm.HS256, JwtHelper.genKey()).compact();
    }

    public static String genToken(String id, String username, Map<String, Object> claimMap, Date createTime) {
        return JwtHelper.genToken(id, username, claimMap, createTime, null);
    }

    public static String genToken(String id, String username, Map<String, Object> claimMap, Date createTime, Date expireTime) {
        if (log.isDebugEnabled()) {
            log.debug("genToken [ id:{} ], [ username:{} ], [ claimMap:{} ], [ createTime:{} ], [ expireTime:{} ]", (Object)id, (Object)username, claimMap, (Object)createTime, (Object)expireTime);
            Key key = JwtHelper.genKey();
            log.debug("genToken [ Issuer:{} ], [ genKey:{} ]", (Object)ApiAccessProperties.props().getToken().getIssuer(), (Object)(key.getAlgorithm() + "|" + key.getFormat() + "|" + key.getEncoded().toString()));
        }
        return Jwts.builder().setId(id).setAudience(username).addClaims(claimMap).setIssuer(ApiAccessProperties.props().getToken().getIssuer()).setIssuedAt(createTime).setExpiration(expireTime).signWith(SignatureAlgorithm.HS256, JwtHelper.genKey()).compact();
    }

    public static Key genKey() {
        return new SecretKeySpec(ApiAccessProperties.props().getToken().getSecretKey().getBytes(), SignatureAlgorithm.HS256.getJcaName());
    }

    public static Jws<Claims> getClaims(String token) {
        return Jwts.parser().setSigningKey(JwtHelper.genKey()).parseClaimsJws(token);
    }
}

