package online.inote.naruto.api.access.props;

import lombok.Data;
import online.inote.naruto.utils.Assert;
import online.inote.naruto.utils.spring.BeanFactory;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

/**
 * @description API授权属性
 * @author XQF.Sui
 * @date 2021/07/30 14:31
 */
@Data
@Component
@ConfigurationProperties(prefix = "naruto.security.api.access")
public class ApiAccessProperties {

  private Cache cache = new Cache();
  private Database database = new Database();
  private HeaderKey headerKey = new HeaderKey();
  private Token token = new Token();

  @Data
  public static class Cache {
    private Boolean enable = true;
    private Long expireTime = -1L;
    private Key key = new Key();

    @Data
    private static class Key {
      private String keyPrefix = "NARUTO:API_ACCESS:";
      private String login = "ADMIN:LOGIN_TOKEN:";
      private String systemInfo = "SYSTEM:INFO:";
      private String systemList = "SYSTEM:LIST";
      private String systemToken = "SYSTEM:TOKEN:INFO:";
      private String manager = "SYSTEM:MANAGER:INFO:";
      private String interfaceInfo = "INTERFACE:INFO:";
      private String systemAuthInterfaceId = "SYSTEM:AUTH_INTERFACE_ID:";
      private String systemAuthInterfacePath = "SYSTEM:AUTH_INTERFACE_PATH:";
      private String interfaceAuthSystem = "INTERFACE:AUTH_SYSTEM_ID:";

      public String init(String functionKey) {
        return this.keyPrefix + functionKey;
      }
    }

    public String getSystemListKey() {
      return key.getSystemList();
    }

    public String initSystemTokenCacheKey(String id) {
      Assert.notBlank(id, "系统ID不能为空");
      return key.init(key.getSystemToken()) + id;
    }

    public String initManagerCacheKey(String id) {
      Assert.notBlank(id, "系统ID不能为空");
      return key.init(key.getManager()) + id;
    }

    public String initSystemAuthInterfacePathCacheKey(String id) {
      Assert.notBlank(id, "系统ID不能为空");
      return key.init(key.getSystemAuthInterfacePath()) + id;
    }

    public String initInterfaceInfoCacheKey(String id) {
      Assert.notBlank(id, "接口ID不能为空");
      return key.init(key.getInterfaceInfo()) + id;
    }

    public String initInterfaceAuthSystemCacheKey(String id) {
      Assert.notBlank(id, "接口ID不能为空");
      return key.init(key.getInterfaceAuthSystem()) + id;
    }
  }

  @Data
  public static class Database {
    private Boolean enable = true;
  }

  @Data
  public static class HeaderKey {
    private String token;
  }

  @Data
  public static class Token {
    /** Token发行者 */
    private String issuer = "NARUTO_SECURITY";
    /** 秘钥 */
    private String secretKey = "eyJhbGciOiJIUzI1NiJ9.eyJqdGkiOiJ";
  }

  public static ApiAccessProperties props() {
    return BeanFactory.getBean(ApiAccessProperties.class);
  }
}
