package online.inote.exception;

/**
 * @description 动作异常
 * @author gaopengsui@creditease.cn
 * @date 2021/09/08 10:05
 */
public final class ActionException {

  private ActionException() {}

  public static class NormalActionException extends InoteException {

    private static final long serialVersionUID = 119960996039652933L;

    public NormalActionException() {
      super();
    }

    public NormalActionException(String message) {
      super(message);
    }

    public NormalActionException(String message, Throwable e) {
      super(message, e);
    }
  }

  public static class UnsupportedActionException extends InoteException {

    private static final long serialVersionUID = 532703116830199614L;

    public UnsupportedActionException() {
      super();
    }

    public UnsupportedActionException(String message) {
      super(message);
    }

    public UnsupportedActionException(String message, Throwable e) {
      super(message, e);
    }
  }
}
