/*
 * Decompiled with CFR 0.152.
 */
package online.inote.commons.utils.time;

import java.util.concurrent.TimeUnit;

public final class Timer {
    private final String name;
    private final long nanosecond;

    private Timer(String name) {
        this.name = name;
        this.nanosecond = System.nanoTime();
    }

    public long stop() {
        return this.stop(TimeUnit.MILLISECONDS);
    }

    public long stop(TimeUnit timeUnit) {
        return timeUnit.convert(System.nanoTime() - this.nanosecond, TimeUnit.NANOSECONDS);
    }

    public String costTipMessage() {
        return this.name + "cost: " + this.stop() + " ms";
    }

    public static TimerWorker builder() {
        return new TimerWorker();
    }

    public static class TimerWorker {
        private String name = "";

        private TimerWorker name(String name) {
            this.name = name;
            return this;
        }

        public Timer build() {
            return new Timer(this.name);
        }
    }
}

