/*
 * Decompiled with CFR 0.152.
 */
package online.inote.commons.utils.time;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import online.inote.commons.utils.Assert;
import online.inote.commons.utils.time.Converter;
import online.inote.commons.utils.time.Zone;

public class Formatter {
    public static String format(LocalDateTime dateTime, DateTimeFormatter pattern, ZoneId zone) {
        Assert.notNull(dateTime, "dateTime cannot be null");
        Assert.notNull(pattern, "pattern cannot be null");
        Assert.notNull(zone, "zone cannot be null");
        return dateTime.format(pattern.withZone(zone));
    }

    public static String format(LocalDateTime dateTime, DateTimeFormatter pattern) {
        return Formatter.format(dateTime, pattern, Zone.DEFAULT);
    }

    public static String format(Date date, DateTimeFormatter pattern) {
        return Formatter.format(Converter.toLocalDateTime(date), pattern);
    }

    public static String format(LocalDate date, DateTimeFormatter pattern, ZoneId zone) {
        Assert.notNull(date, "date cannot be null");
        Assert.notNull(pattern, "pattern cannot be null");
        Assert.notNull(zone, "zone cannot be null");
        return date.format(pattern.withZone(zone));
    }

    public static String format(LocalDate date, DateTimeFormatter pattern) {
        return Formatter.format(date, pattern, Zone.DEFAULT);
    }

    public static String format(LocalTime time, DateTimeFormatter pattern, ZoneId zone) {
        Assert.notNull(time, "time cannot be null");
        Assert.notNull(pattern, "pattern cannot be null");
        Assert.notNull(zone, "zone cannot be null");
        return time.format(pattern.withZone(zone));
    }

    public static String format(LocalTime time, DateTimeFormatter pattern) {
        return Formatter.format(time, pattern, Zone.DEFAULT);
    }

    public static LocalDateTime parse(String dateStr, DateTimeFormatter pattern, ZoneId zone) {
        Assert.notBlank(dateStr, "dateStr cannot be blank");
        Assert.notNull(pattern, "pattern cannot be null");
        Assert.notNull(zone, "zone cannot be null");
        return Converter.toLocalDateTime(pattern.withZone(zone).parse(dateStr));
    }

    public static LocalDateTime parse(String dateStr, DateTimeFormatter pattern) {
        return Formatter.parse(dateStr, pattern, Zone.DEFAULT);
    }

    public static Date parseDate(String dateStr, DateTimeFormatter pattern) {
        return Converter.toDate(Formatter.parse(dateStr, pattern));
    }

    public static LocalDate parseLocalDate(String dateStr, DateTimeFormatter pattern) {
        return Converter.toLocalDate(Formatter.parse(dateStr, pattern));
    }

    public static LocalTime parseLocalTime(String dateStr, DateTimeFormatter pattern) {
        return Converter.toLocalTime(Formatter.parse(dateStr, pattern));
    }
}

