/*
 * Decompiled with CFR 0.152.
 */
package online.inote.commons.utils.time;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.temporal.TemporalUnit;
import java.util.Date;
import online.inote.commons.utils.Assert;
import online.inote.commons.utils.time.Converter;
import online.inote.commons.utils.time.Formatter;
import online.inote.commons.utils.time.Pattern;

public class Calculator {
    public static LocalDateTime getNow() {
        return LocalDateTime.now();
    }

    public static Date getNowDate() {
        return Converter.toDate(Calculator.getNow());
    }

    public static LocalDate getNowLocalDate() {
        return LocalDate.now();
    }

    public static LocalTime getNowLocalTime() {
        return LocalTime.now();
    }

    public static Date plus(Date date, long stepSize, TemporalUnit unit) {
        Assert.notNull(date, "date cannot be null");
        Assert.notNull(unit, "unit cannot be null");
        return Converter.toDate(Converter.toLocalDateTime(date).plus(stepSize, unit));
    }

    public static Date minus(Date date, long stepSize, TemporalUnit unit) {
        Assert.notNull(date, "date cannot be null");
        Assert.notNull(unit, "unit cannot be null");
        return Converter.toDate(Converter.toLocalDateTime(date).minus(stepSize, unit));
    }

    public static LocalTime endTimeOfDay() {
        return LocalTime.MAX.withNano(0);
    }

    public static Date endTimeOfToday() {
        return Converter.toDate(Calculator.getNowLocalDate().atTime(Calculator.endTimeOfDay()));
    }

    public static void main(String[] args) {
        System.out.println(Formatter.format(Calculator.endTimeOfToday(), Pattern.DateTimeFormatters.YYYY_MM_DD_HH_MM_SS_SSS));
    }
}

