/*
 * Decompiled with CFR 0.152.
 */
package online.inote.commons.utils.response;

import online.inote.commons.utils.StringUtils;
import online.inote.commons.utils.response.Code;
import online.inote.commons.utils.response.I18nResponse;

public class ExtendResponse<T>
extends I18nResponse<T> {
    private static final long serialVersionUID = 4713365336941955492L;

    ExtendResponse() {
    }

    public ExtendResponse(String code, String message) {
        super(code, message);
    }

    public ExtendResponse(String code, String message, T data) {
        super(code, message, data);
    }

    public static <T> ExtendResponse<T> success() {
        return new ExtendResponse<T>(Code.SUCCESS.getCode(), Code.SUCCESS.getMessage(new Object[0]));
    }

    public static <T> ExtendResponse<T> success(T data) {
        return new ExtendResponse<T>(Code.SUCCESS.getCode(), Code.SUCCESS.getMessage(new Object[0]), data);
    }

    public static <T> ExtendResponse<T> fail() {
        return new ExtendResponse<T>(Code.FAIL.getCode(), Code.FAIL.getMessage(new Object[0]));
    }

    public static <T> ExtendResponse<T> success(T data, String message) {
        return new ExtendResponse<T>(Code.SUCCESS.getCode(), message, data);
    }

    public static <T> ExtendResponse<T> fail(String message) {
        return new ExtendResponse<T>(Code.FAIL.getCode(), message);
    }

    public static <T> ExtendResponse<T> fail(String messageTemplate, Object ... args) {
        return new ExtendResponse<T>(Code.FAIL.getCode(), StringUtils.format(messageTemplate, args));
    }

    public static <T> ExtendResponse<T> create(Code code, String message, T data) {
        return new ExtendResponse<T>(code.getCode(), message, data);
    }
}

