/*
 * Decompiled with CFR 0.152.
 */
package online.inote.commons.utils.response;

import online.inote.commons.utils.i18n.I18n;
import online.inote.commons.utils.i18n.spring.boot.props.ResponseI18nProperties;

public class Code {
    public static final Code SUCCESS = Code.of("A10001");
    public static final Code FAIL = Code.of("A10002");
    public static final Code PARAM_REQUIRED = Code.of("A10003");
    public static final Code NOT_EXISTS = Code.of("A10004");
    public static final Code EXISTS = Code.of("A10005");
    public static final Code OWN_PERMISSION = Code.of("A10006");
    public static final Code NOT_PERMISSION = Code.of("A10007");
    public static final Code TOKEN_ILLEGAL = Code.of("A50008");
    public static final Code TOKEN_EXPIRED = Code.of("A50014");
    private final String code;

    public String getCode() {
        return this.code;
    }

    protected Code(String code) {
        this.code = code;
    }

    public String getMessage(Object ... args) {
        return I18n.message(Code.getResponseBundle(), this.code, args);
    }

    public static String getMessage(String code, Object ... args) {
        return I18n.message(Code.getResponseBundle(), code, args);
    }

    public static String getResponseBundle() {
        return ResponseI18nProperties.props().getResponseBundle();
    }

    public static Code of(String code) {
        return new Code(code);
    }
}

