/*
 * Decompiled with CFR 0.152.
 */
package online.inote.commons.utils.http;

import java.util.concurrent.TimeUnit;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import online.inote.commons.utils.http.DefaultResultConvertor;
import online.inote.commons.utils.http.LogInterceptor;
import online.inote.commons.utils.http.ResultConvertor;
import online.inote.commons.utils.http.SyncRequest;

public class Http {
    private OkHttpClient client;
    private ResultConvertor convertor;

    public Http(Builder builder) {
        this.buildInstance(builder);
    }

    private void buildInstance(Builder builderProps) {
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        builder.hostnameVerifier((hostname, session) -> true);
        builder.addInterceptor((Interceptor)new LogInterceptor());
        builder.connectTimeout(builderProps.connectTimeout, TimeUnit.MILLISECONDS);
        builder.writeTimeout(builderProps.writeTimeout, TimeUnit.MILLISECONDS);
        builder.readTimeout(builderProps.readTimeout, TimeUnit.MILLISECONDS);
        this.client = builder.build();
        this.convertor = builderProps.convertor;
    }

    public SyncRequest sync() {
        return SyncRequest.builder().client(this.client).convertor(this.convertor).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private long connectTimeout = 5000L;
        private long writeTimeout = 5000L;
        private long readTimeout = 5000L;
        private ResultConvertor convertor = new DefaultResultConvertor();

        public Builder connectTimeout(long connectTimeout) {
            this.connectTimeout = connectTimeout;
            return this;
        }

        public Builder writeTimeout(long writeTimeout) {
            this.writeTimeout = writeTimeout;
            return this;
        }

        public Builder readTimeOut(long readTimeout) {
            this.readTimeout = readTimeout;
            return this;
        }

        public Builder convertor(ResultConvertor convertor) {
            this.convertor = convertor;
            return this;
        }

        public Http build() {
            return new Http(this);
        }
    }
}

