/*
 * Decompiled with CFR 0.152.
 */
package online.inote.commons.utils;

import java.io.Serializable;
import java.util.Map;
import java.util.Objects;
import online.inote.exception.ArgumentException;
import org.apache.commons.collections4.MapUtils;

public class StringUtils
extends org.apache.commons.lang3.StringUtils {
    private static final String TEMPLATE_PLACEHOLDER_PREFIX = "{";
    private static final String TEMPLATE_PLACEHOLDER_SUFFIX = "}";

    public static String format(String template, Object ... params) {
        if (StringUtils.isBlank((CharSequence)template) || Objects.isNull(params)) {
            return template;
        }
        for (int i = 0; i < params.length && template.contains(TEMPLATE_PLACEHOLDER_PREFIX); ++i) {
            int strLen;
            int index = template.indexOf(TEMPLATE_PLACEHOLDER_SUFFIX);
            template = index == (strLen = template.length()) - 1 ? template.substring(0, template.indexOf(TEMPLATE_PLACEHOLDER_PREFIX)) + params[i] : template.substring(0, template.indexOf(TEMPLATE_PLACEHOLDER_PREFIX)) + params[i] + template.substring(template.indexOf(TEMPLATE_PLACEHOLDER_SUFFIX) + 1);
        }
        return template;
    }

    public static String startAt(String str, CharSequence prefix) {
        if (StringUtils.startsWith((CharSequence)str, (CharSequence)prefix)) {
            return str;
        }
        return prefix + str;
    }

    public static String endAt(String str, CharSequence suffix) {
        if (StringUtils.endsWith((CharSequence)str, (CharSequence)suffix)) {
            return str;
        }
        return str + suffix;
    }

    public static Long convertToLong(String str) {
        if (!StringUtils.isNumeric((CharSequence)str)) {
            throw new ArgumentException(StringUtils.format("\u975e\u6cd5\u53c2\u6570:[ {} ]", str));
        }
        return Long.valueOf(str);
    }

    public static Integer convertToInteger(String str) {
        if (!StringUtils.isNumeric((CharSequence)str)) {
            throw new ArgumentException(StringUtils.format("\u975e\u6cd5\u53c2\u6570:[ {} ]", str));
        }
        return Integer.valueOf(str);
    }

    public static String convertToUrlParams(Map<String, String> paramMap) {
        if (MapUtils.isNotEmpty(paramMap)) {
            StringBuffer sb = new StringBuffer("?");
            paramMap.forEach((key, val) -> sb.append((String)key).append('=').append((String)val).append('&'));
            return StringUtils.trimTrailingCharacter(sb.toString(), '&');
        }
        return "";
    }

    public static String trimTrailingCharacter(String str, char trailingCharacter) {
        if (StringUtils.isBlank((CharSequence)str)) {
            return str;
        }
        StringBuilder sb = new StringBuilder(str);
        while (sb.length() > 0 && sb.charAt(sb.length() - 1) == trailingCharacter) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    public static void main(String[] args) {
        System.out.println(StringUtils.join((Object[])new Serializable[]{"LIMIT ", Integer.valueOf(2), " ", Integer.valueOf(10)}));
    }
}

