package online.inote.commons.utils.time;

/**
 * @description 时区枚举(摘自ZoneId.SHORT_IDS)
 * @author gaopengsui@creditease.cn
 * @date 2021/9/13 17:00
 */
public enum ZoneEnum {
  ACT("Australia/Darwin", "澳大利亚/达尔文"),
  AET("Australia/Sydney", "澳大利亚/悉尼"),
  AGT("America/Argentina/Buenos_Aires", "美国/阿根廷/布宜诺斯艾利斯"),
  ART("Africa/Cairo", "非洲/开罗"),
  AST("America/Anchorage", "美国/安克雷奇"),
  BET("America/Sao_Paulo", "美国/圣保罗"),
  BST("Asia/Dhaka", "亚洲/达卡"),
  CAT("Africa/Harare", "非洲/哈拉雷"),
  CNT("America/St_Johns", "美国/圣约翰"),
  CST("America/Chicago", "美国/芝加哥"),
  CTT("Asia/Shanghai", "亚洲/上海"),
  EAT("Africa/Addis_Ababa", "非洲/亚的斯亚贝巴"),
  ECT("Europe/Paris", "欧洲/巴黎"),
  IET("America/Indiana/Indianapolis", "美国/印第安纳州/印第安纳波利斯"),
  IST("Asia/Kolkata", "亚洲/加尔各答"),
  JST("Asia/Tokyo", "亚洲/东京"),
  MIT("Pacific/Apia", "太平洋/阿皮亚"),
  NET("Asia/Yerevan", "亚洲/埃里温"),
  NST("Pacific/Auckland", "太平洋/奥克兰"),
  PLT("Asia/Karachi", "亚洲/卡拉奇"),
  PNT("America/Phoenix", "美国/凤凰城"),
  PRT("America/Puerto_Rico", "美国/波多黎各"),
  PST("America/Los_Angeles", "美国/洛杉矶"),
  SST("Pacific/Guadalcanal", "太平洋/瓜达尔卡纳尔岛"),
  VST("Asia/Ho_Chi_Minh", "亚洲/胡志明市(越南标准时间)"),
  EST("-05:00", "北美东部标准时间"),
  MST("-07:00", "北美山地标准时间"),
  HST("-10:00", "夏威夷标准时间");

  private String name;
  private String nameCN;

  ZoneEnum(String name, String nameCN) {
    this.name = name;
    this.nameCN = nameCN;
  }

  public String getName() {
    return name;
  }

  public String getNameCN() {
    return nameCN;
  }
}
