package online.inote.commons.utils.time;

import java.time.format.DateTimeFormatter;

/**
 * @description TODO
 * @author gaopengsui@creditease.cn
 * @date 2021/09/10 18:21
 */
public class Pattern extends Format {

  public static class DateFormatters {

    /** 日期格式:YYYY-MM-DD 例如:2021-09-13 */
    public static final DateTimeFormatter YYYY_MM_DD = DateTimeFormatter.ofPattern(Date.YYYY_MM_DD);

    /** 日期格式:YYYY-M-D 例如:2021-9-13 */
    public static final DateTimeFormatter YYYY_M_D = DateTimeFormatter.ofPattern(Date.YYYY_M_D);

    /** 日期格式:YYYYMMDD 例如:20210913 */
    public static final DateTimeFormatter YYYY_MM_DD_SHORT =
        DateTimeFormatter.ofPattern(Date.YYYY_MM_DD_SHORT);

    /** 日期格式:YYYY/MM/DD 例如:2021/09/13 */
    public static final DateTimeFormatter YYYY_MM_DD_EN =
        DateTimeFormatter.ofPattern(Date.YYYY_MM_DD_EN);

    /** 日期格式:YYYY/M/D 例如:2021/9/13 */
    public static final DateTimeFormatter YYYY_M_D_EN =
        DateTimeFormatter.ofPattern(Date.YYYY_M_D_EN);

    /** 日期格式:YYYY年MM月DD日 例如:2021年09月13日 */
    public static final DateTimeFormatter YYYY_MM_DD_CN =
        DateTimeFormatter.ofPattern(Date.YYYY_MM_DD_CN);

    /** 日期格式:YYYY年M月D日 例如:2021年9月13日 */
    public static final DateTimeFormatter YYYY_M_D_CN =
        DateTimeFormatter.ofPattern(Date.YYYY_M_D_CN);

    /** 日期格式:YYYY.MM.DD 例如:2021.09.13 */
    public static final DateTimeFormatter YYYY_MM_DD_POINT =
        DateTimeFormatter.ofPattern(Date.YYYY_MM_DD_POINT);

    /** 日期格式:YYYY.M.D 例如:2021.9.13 */
    public static final DateTimeFormatter YYYY_M_D_POINT =
        DateTimeFormatter.ofPattern(Date.YYYY_M_D_POINT);

    /** 日期格式:YY.MM.DD 例如:21/9/13 */
    public static final DateTimeFormatter YY_MM_DD_EN =
        DateTimeFormatter.ofPattern(Date.YY_MM_DD_EN);

    /** 日期格式:YY/M/D 例如:21/9/13 */
    public static final DateTimeFormatter YY_M_D_EN = DateTimeFormatter.ofPattern(Date.YY_M_D_EN);

    /** 日期格式:MM/DD/YY 例如:09/13/21 */
    public static final DateTimeFormatter MM_DD_YY_EN =
        DateTimeFormatter.ofPattern(Date.MM_DD_YY_EN);

    /** 日期格式:M/D/YY 例如:9/13/21 */
    public static final DateTimeFormatter M_D_YY_EN = DateTimeFormatter.ofPattern(Date.M_D_YY_EN);

    /** 日期格式:YYYY-MM-DD E 例如:2021-09-13 星期一 */
    public static final DateTimeFormatter YYYY_MM_DD_E =
        DateTimeFormatter.ofPattern(Date.YYYY_MM_DD_E);

    /** 日期格式:YY 例如:21 */
    public static final DateTimeFormatter YY = DateTimeFormatter.ofPattern(Date.YY);

    /** 日期格式:YY年 例如:21年 */
    public static final DateTimeFormatter YY_CN = DateTimeFormatter.ofPattern(Date.YY_CN);

    /** 日期格式:YYYY 例如:2021 */
    public static final DateTimeFormatter YYYY = DateTimeFormatter.ofPattern(Date.YYYY);

    /** 日期格式:YYYY年 例如:2021年 */
    public static final DateTimeFormatter YYYY_CN = DateTimeFormatter.ofPattern(Date.YYYY_CN);

    /** 日期格式:YYYY-MM 例如:2021-09 */
    public static final DateTimeFormatter YYYY_MM = DateTimeFormatter.ofPattern(Date.YYYY_MM);

    /** 日期格式:YYYYMM 例如:202109 */
    public static final DateTimeFormatter YYYY_MM_SHORT =
        DateTimeFormatter.ofPattern(Date.YYYY_MM_SHORT);

    /** 日期格式:YYYY/MM 例如:2021/09 */
    public static final DateTimeFormatter YYYY_MM_EN = DateTimeFormatter.ofPattern(Date.YYYY_MM_EN);

    /** 日期格式:YYYY年MM月 例如:2021年09月 */
    public static final DateTimeFormatter YYYY_MM_CN = DateTimeFormatter.ofPattern(Date.YYYY_MM_CN);

    /** 日期格式:YYYY年M月 例如:2021年9月 */
    public static final DateTimeFormatter YYYY_M_CN = DateTimeFormatter.ofPattern(Date.YYYY_M_CN);

    /** 日期格式:MM-DD 例如:09-13 */
    public static final DateTimeFormatter MM_DD = DateTimeFormatter.ofPattern(Date.MM_DD);

    /** 日期格式:MMDD 例如:0913 */
    public static final DateTimeFormatter MM_DD_SHORT =
        DateTimeFormatter.ofPattern(Date.MM_DD_SHORT);

    /** 日期格式:MM/DD 例如:09/13 */
    public static final DateTimeFormatter MM_DD_EN = DateTimeFormatter.ofPattern(Date.MM_DD_EN);

    /** 日期格式:M/D 例如:9/13 */
    public static final DateTimeFormatter M_D_EN = DateTimeFormatter.ofPattern(Date.M_D_EN);

    /** 日期格式:MM月DD日 例如:09月13日 */
    public static final DateTimeFormatter MM_DD_CN = DateTimeFormatter.ofPattern(Date.MM_DD_CN);

    /** 日期格式:M月D日 例如:9月13日 */
    public static final DateTimeFormatter M_D_CN = DateTimeFormatter.ofPattern(Date.M_D_CN);
  }

  public static class TimeFormatters {

    /** 时间格式:HH:MM:SS 例如:23:08:45 */
    public static final DateTimeFormatter HH_MM_SS = DateTimeFormatter.ofPattern(Time.HH_MM_SS);

    /** 时间格式:H:M:S 例如:23:8:45 */
    public static final DateTimeFormatter H_M_S = DateTimeFormatter.ofPattern(Time.H_M_S);

    /** 时间格式:HHMMSS 例如:230845 */
    public static final DateTimeFormatter HH_MM_SS_SHORT =
        DateTimeFormatter.ofPattern(Time.HH_MM_SS_SHORT);

    /** 时间格式:HH时MM分SS秒 例如:23时08分45秒 */
    public static final DateTimeFormatter HH_MM_SS_CN =
        DateTimeFormatter.ofPattern(Time.HH_MM_SS_CN);

    /** 时间格式:HH:MM 例如:23:08 */
    public static final DateTimeFormatter HH_MM = DateTimeFormatter.ofPattern(Time.HH_MM);

    /** 时间格式:H:M 例如:23:8 */
    public static final DateTimeFormatter H_M = DateTimeFormatter.ofPattern(Time.H_M);

    /** 时间格式:HH时MM分 例如:23时08分 */
    public static final DateTimeFormatter HH_MM_CN = DateTimeFormatter.ofPattern(Time.HH_MM_CN);

    /** 时间格式:HH:MM 上午/下午 例如:11:08 下午 */
    public static final DateTimeFormatter HH_MM_A = DateTimeFormatter.ofPattern(Time.HH_MM_A);

    /** 时间格式:HH:MM:SS.SSS 例如:23:08:45.698 */
    public static final DateTimeFormatter HH_MM_SS_SSS =
        DateTimeFormatter.ofPattern(Time.HH_MM_SS_SSS);
  }

  public static class DateTimeFormatters {

    /** 时间格式:yyyy-MM-dd HH:mm:ss 例如:2021-09-13 23:08:45 */
    public static final DateTimeFormatter YYYY_MM_DD_HH_MM_SS =
        DateTimeFormatter.ofPattern(DateTime.YYYY_MM_DD_HH_MM_SS);

    /** 时间格式:yyyy-M-d H:m:s 例如:2021-9-13 23:8:45 */
    public static final DateTimeFormatter YYYY_M_D_H_M_S =
        DateTimeFormatter.ofPattern(DateTime.YYYY_M_D_H_M_S);

    /** 时间格式:yyyyMMddHHmmss 例如:20210913230845 */
    public static final DateTimeFormatter YYYY_MM_DD_HH_MM_SS_SHORT =
        DateTimeFormatter.ofPattern(DateTime.YYYY_MM_DD_HH_MM_SS_SHORT);

    /** 时间格式:yyyy/MM/dd HH:mm:ss 例如:2021/09/13 23:08:45 */
    public static final DateTimeFormatter YYYY_MM_DD_HH_MM_SS_EN =
        DateTimeFormatter.ofPattern(DateTime.YYYY_MM_DD_HH_MM_SS_EN);

    /** 时间格式:yyyy/M/d H:m:s 例如:2021/9/13 23:8:45 */
    public static final DateTimeFormatter YYYY_M_D_H_M_S_EN =
        DateTimeFormatter.ofPattern(DateTime.YYYY_M_D_H_M_S_EN);

    /** 时间格式:yyyy年MM月dd日 HH:mm:ss 例如:2021年09月13日 23:08:45 */
    public static final DateTimeFormatter YYYY_MM_DD_CN_HH_MM_SS =
        DateTimeFormatter.ofPattern(DateTime.YYYY_MM_DD_CN_HH_MM_SS);

    /** 时间格式:yyyy年MM月dd日 HH时mm分ss秒 例如:2021年09月13日 23时08分45秒 */
    public static final DateTimeFormatter YYYY_MM_DD_HH_MM_SS_CN =
        DateTimeFormatter.ofPattern(DateTime.YYYY_MM_DD_HH_MM_SS_CN);

    /** 时间格式:yyyy-MM-dd HH:mm 例如:2021-09-13 23:08 */
    public static final DateTimeFormatter YYYY_MM_DD_HH_MM =
        DateTimeFormatter.ofPattern(DateTime.YYYY_MM_DD_HH_MM);

    /** 时间格式:yyyy-M-d H:m 例如:2021-9-13 23:8 */
    public static final DateTimeFormatter YYYY_M_D_H_M =
        DateTimeFormatter.ofPattern(DateTime.YYYY_M_D_H_M);

    /** 时间格式:yyyyMMddHHmm 例如:202109132308 */
    public static final DateTimeFormatter YYYY_MM_DD_HH_MM_SHORT =
        DateTimeFormatter.ofPattern(DateTime.YYYY_MM_DD_HH_MM_SHORT);

    /** 时间格式:yyyy/MM/dd HH:mm 例如:2021/09/13 23:08 */
    public static final DateTimeFormatter YYYY_MM_DD_HH_MM_EN =
        DateTimeFormatter.ofPattern(DateTime.YYYY_MM_DD_HH_MM_EN);

    /** 时间格式:yyyy/M/d H:m 例如:2021/9/13 23:8 */
    public static final DateTimeFormatter YYYY_M_D_H_M_EN =
        DateTimeFormatter.ofPattern(DateTime.YYYY_M_D_H_M_EN);

    /** 时间格式:yyyy/M/d H:m 上午/下午 例如:2021/9/13 11:8 下午 */
    public static final DateTimeFormatter YYYY_M_D_H_M_A_EN =
        DateTimeFormatter.ofPattern(DateTime.YYYY_M_D_H_M_A_EN);

    /** 时间格式:MM-dd HH:mm 例如:09-13 23:08 */
    public static final DateTimeFormatter MM_DD_HH_MM =
        DateTimeFormatter.ofPattern(DateTime.MM_DD_HH_MM);

    /** 时间格式:MM月dd日 HH:mm 例如:09月13日 23:08 */
    public static final DateTimeFormatter MM_DD_CN_HH_MM =
        DateTimeFormatter.ofPattern(DateTime.MM_DD_CN_HH_MM);

    /** 时间格式:MM月dd日 HH时mm分 例如:09月13日 23时08分 */
    public static final DateTimeFormatter MM_DD_HH_MM_CN =
        DateTimeFormatter.ofPattern(DateTime.MM_DD_HH_MM_CN);

    /** 时间格式:MM-dd HH:mm:ss 例如:09-13 23:08:45 */
    public static final DateTimeFormatter MM_DD_HH_MM_SS =
        DateTimeFormatter.ofPattern(DateTime.MM_DD_HH_MM_SS);

    /** 时间格式:MM月dd日 HH:mm:ss 例如:09月13日 23:08:45 */
    public static final DateTimeFormatter MM_DD_CN_HH_MM_SS =
        DateTimeFormatter.ofPattern(DateTime.MM_DD_CN_HH_MM_SS);

    /** 时间格式:MM月dd日 HH时mm分ss秒 例如:09月13日 23时08分45秒 */
    public static final DateTimeFormatter MM_DD_HH_MM_SS_CN =
        DateTimeFormatter.ofPattern(DateTime.MM_DD_HH_MM_SS_CN);

    /** 时间格式:yyyy年MM月dd日 HH:mm:ss 上午/下午 例如:2021年09月13日 11:08:45 下午 */
    public static final DateTimeFormatter YYYY_MM_DD_CN_HH_MM_SS_A =
        DateTimeFormatter.ofPattern(DateTime.YYYY_MM_DD_CN_HH_MM_SS_A);

    /** 时间格式:yyyy年MM月dd日 HH时mm分ss秒 上午/下午 例如:2021年09月13日 11时08分45秒 下午 */
    public static final DateTimeFormatter YYYY_MM_DD_HH_MM_SS_A_CN =
        DateTimeFormatter.ofPattern(DateTime.YYYY_MM_DD_HH_MM_SS_A_CN);

    /** 时间格式:yyyy-MM-dd HH:mm:ss.sss 例如:2021-09-13 23:08:45.698 */
    public static final DateTimeFormatter YYYY_MM_DD_HH_MM_SS_SSS =
        DateTimeFormatter.ofPattern(DateTime.YYYY_MM_DD_HH_MM_SS_SSS);

    /** 时间格式:yyyyMMddHHmmssSSS 例如:20210913230845698 */
    public static final DateTimeFormatter YYYY_MM_DD_HH_MM_SS_SSS_SHORT =
        DateTimeFormatter.ofPattern(DateTime.YYYY_MM_DD_HH_MM_SS_SSS_SHORT);

    /** 时间格式:yyyy-M-d H:m:s.SSS 例如:2021-9-13 23:8:45.698 */
    public static final DateTimeFormatter YYYY_M_D_H_M_S_SSS =
        DateTimeFormatter.ofPattern(DateTime.YYYY_M_D_H_M_S_SSS);

    /** 时间格式:yyyy/M/d H:m:s.SSS 例如:2021/9/13 23:8:45.698 */
    public static final DateTimeFormatter YYYY_M_D_H_M_S_SSS_EN =
        DateTimeFormatter.ofPattern(DateTime.YYYY_M_D_H_M_S_SSS_EN);

    /** 时间格式:EEE MMM dd HH:mm:ss zzz yyyy 例如:星期一 九月 13 23:08:45 CT 2021 */
    public static final DateTimeFormatter EEE_MMM_DD_HH_MM_SS_ZZZ_YYYY =
        DateTimeFormatter.ofPattern(DateTime.EEE_MMM_DD_HH_MM_SS_ZZZ_YYYY);
  }
}
