package online.inote.commons.utils.time;

import online.inote.commons.utils.Assert;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Date;

/**
 * @description 日期时间格式化
 * @author gaopengsui@creditease.cn
 * @date 2021/09/10 16:24
 */
public class Formatter {

  public static String format(LocalDateTime dateTime, DateTimeFormatter pattern, ZoneId zone) {
    Assert.notNull(dateTime, "dateTime cannot be null");
    Assert.notNull(pattern, "pattern cannot be null");
    Assert.notNull(zone, "zone cannot be null");
    return dateTime.format(pattern.withZone(zone));
  }

  public static String format(LocalDateTime dateTime, DateTimeFormatter pattern) {
    return format(dateTime, pattern, Zone.DEFAULT);
  }

  public static String format(Date date, DateTimeFormatter pattern) {
    return format(Converter.toLocalDateTime(date), pattern);
  }

  public static String format(LocalDate date, DateTimeFormatter pattern, ZoneId zone) {
    Assert.notNull(date, "date cannot be null");
    Assert.notNull(pattern, "pattern cannot be null");
    Assert.notNull(zone, "zone cannot be null");
    return date.format(pattern.withZone(zone));
  }

  public static String format(LocalDate date, DateTimeFormatter pattern) {
    return format(date, pattern, Zone.DEFAULT);
  }

  public static String format(LocalTime time, DateTimeFormatter pattern, ZoneId zone) {
    Assert.notNull(time, "time cannot be null");
    Assert.notNull(pattern, "pattern cannot be null");
    Assert.notNull(zone, "zone cannot be null");
    return time.format(pattern.withZone(zone));
  }

  public static String format(LocalTime time, DateTimeFormatter pattern) {
    return format(time, pattern, Zone.DEFAULT);
  }

  public static LocalDateTime parse(String dateStr, DateTimeFormatter pattern, ZoneId zone) {
    Assert.notBlank(dateStr, "dateStr cannot be blank");
    Assert.notNull(pattern, "pattern cannot be null");
    Assert.notNull(zone, "zone cannot be null");
    return Converter.toLocalDateTime(pattern.withZone(zone).parse(dateStr));
  }

  public static LocalDateTime parse(String dateStr, DateTimeFormatter pattern) {
    return parse(dateStr, pattern, Zone.DEFAULT);
  }

  public static Date parseDate(String dateStr, DateTimeFormatter pattern) {
    return Converter.toDate(parse(dateStr, pattern));
  }

  public static LocalDate parseLocalDate(String dateStr, DateTimeFormatter pattern) {
    return Converter.toLocalDate(parse(dateStr, pattern));
  }

  public static LocalTime parseLocalTime(String dateStr, DateTimeFormatter pattern) {
    return Converter.toLocalTime(parse(dateStr, pattern));
  }
}
