package online.inote.commons.utils.http;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.util.List;

/**
 * @description 结果转换器
 * @author gaopengsui@creditease.cn
 * @date 2021/10/08 7:34 下午
 */
public interface ResultConvertor {

  /**
   * 转换映射
   *
   * @param resultBody 返回结果
   * @return
   */
  String mapping(String resultBody);

  /**
   * Bean转换
   *
   * @param type 类型
   * @param in 输入数据
   * @param charset 字符设置
   * @param <T> 泛型
   * @return
   * @throws IOException
   */
  <T> T toBean(Type type, InputStream in, Charset charset);

  /**
   * 转换为List
   *
   * @param clazz 类型
   * @param in 输入数据
   * @param charset 字符设置
   * @param <T> 泛型
   * @return List集合
   */
  <T> List<T> toList(Class<T> clazz, InputStream in, Charset charset);
}
