package online.inote.commons.utils.http;

import okhttp3.MediaType;

import java.io.IOException;
import java.util.Map;

/**
 * @description Http请求任务
 * @author gaopengsui@creditease.cn
 * @date 2021/10/08 4:19 下午
 */
public abstract class Request {

  public static final MediaType APPLICATION_JSON =
      MediaType.parse("application/json; charset=utf-8");

  protected String baseUrl;
  protected String url;
  protected String targetUrl;
  protected Object requestBody;
  protected Map<String, String> headerParamMap;
  protected Map<String, String> urlParamMap;
  protected Map<String, Object> requestBodyMap;
  protected MediaType mediaType = APPLICATION_JSON;

  /**
   * GET请求
   *
   * @return
   * @throws IOException
   */
  protected abstract Result get();

  /**
   * POST请求
   *
   * @return
   */
  public abstract Result post();

  /**
   * PUT请求
   *
   * @return
   */
  public abstract Result put();

  /**
   * DELETE请求
   *
   * @return
   */
  public abstract Result delete();

  public Request setRequestBody(Object params) {
    this.requestBody = params;
    return this;
  }

  public Request setRequestBody(String key, Object val) {
    this.requestBodyMap.put(key, val);
    return this;
  }

  public Request setHeaderParam(String key, String val) {
    this.headerParamMap.put(key, val);
    return this;
  }

  public Request setHeaderParam(Map<String, String> headerParamMap) {
    this.headerParamMap = headerParamMap;
    return this;
  }

  public Request setUrlParam(String key, String val) {
    this.urlParamMap.put(key, val);
    return this;
  }

  public Request setUrlParam(Map<String, String> headerParamMap) {
    this.urlParamMap = headerParamMap;
    return this;
  }

  public Request setMediaType(MediaType mediaType) {
    this.mediaType = mediaType;
    return this;
  }

  public Request setBaseUrl(String baseUrl) {
    this.baseUrl = baseUrl;
    this.targetUrl = this.baseUrl + this.url;
    return this;
  }

  public Request setUrl(String url) {
    this.url = url;
    this.targetUrl = this.baseUrl + this.url;
    return this;
  }

  public Request setTargetUrl(String targetUrl) {
    this.targetUrl = targetUrl;
    return this;
  }
}
