package online.inote.commons.utils.http;

import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okio.Buffer;
import online.inote.commons.utils.time.Timer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.IOException;

/**
 * @description 日志
 * @author gaopengsui@creditease.cn
 * @date 2021/06/01 14:04
 */
public class LogInterceptor implements Interceptor {

  private static final String POST_METHOD = "POST";

  private final Logger logger = LoggerFactory.getLogger(getClass());

  @Override
  public Response intercept(Chain chain) throws IOException {
    Request request = chain.request();
    logger.info("request:[ {} ]" + request.toString());

    if (POST_METHOD.equals(request.method())) {
      logger.info("request-headers:[ {} ]", request.headers().toString());
      RequestBody requestBody = request.body();
      Buffer buffer = new Buffer();
      requestBody.writeTo(buffer);

      logger.info("request-contentType:[ {} ]", requestBody.contentType().toString());
      logger.info("request-body:[ {} ]", buffer.readByteString().utf8());
    }

    Timer timer = Timer.builder().build();
    Response response = chain.proceed(request);

    // 打印请求耗时
    logger.info(timer.costTipMessage());
    logger.info("response-code:[ {} ]", response.code());

    return response;
  }
}
