package online.inote.commons.utils;

import lombok.Data;

import java.util.List;
import java.util.Objects;

/**
 * @description 分页
 * @author gaopengsui@creditease.cn
 * @date 2017年12月4日 上午11:03:54
 */
@Data
public class Page<T> {

  /** 当前页 默认第一页 */
  private int page = 1;

  /** 每页显示条数 默认每页显示10条 */
  private int rows = 10;

  /** 总页数 */
  private long totalPage;

  /** 总数 */
  private long records;

  /** 是否有下一页 */
  private boolean hasNext;

  /** 是否有上一页 */
  private boolean hasPrevious;

  /** 获取的数据 */
  private List<T> dataList;

  /** 分页搜索参数对象 */
  private T searchParams;

  public Page() {}

  public Page(int page, int rows) {
    this();
    this.page = page > 0 ? page : 1;
    this.rows = rows > 0 ? rows : 30;
  }

  public Page(int page, int rows, long records) {
    this(page, rows);
    this.setRecords(records);
  }

  public void setRecords(Long records) {
    if (Objects.nonNull(records)) {
      this.records = records;
      this.totalPage = (long) Math.ceil((double) records / this.rows);
      this.hasNext = this.totalPage > this.page;
      this.hasPrevious = this.page > 1;
    }
  }

  /**
   * 像Elasticsearch、JPA等分页从0开始使用该方法，如果分页是从1开始请使用getPage
   *
   * @return
   */
  public int getStartZeroPage() {
    return this.page > 0 ? this.page - 1 : 0;
  }

  public int getStart() {
    return (this.page - 1) * this.rows;
  }
}
