(ns leiningen.new.om-weasel
  (:require [leiningen.new.templates :refer [project-name multi-segment year
                                             sanitize sanitize-ns
                                             renderer name-to-path ->files]]
            [leiningen.core.main :as main]))

(defn om-weasel
  "A lein template for creating an nREPL compliant Om project that provides
  a Weasel based repl."
  [name]
  (let [render (renderer "om-weasel")
        main-ns (multi-segment (sanitize-ns name))
        data {:raw-name name
              :name (project-name name)
              :namespace main-ns
              :sanitized (name-to-path name)
              :nested-dirs (name-to-path main-ns)
              :year (year)}]
    (main/info "Generating fresh 'lein new' om-weasel project.")
    (->files data
             [".gitignore" (render "gitignore" data)]
             ["README.md" (render "README.md" data)]
             ["doc/intro.md" (render "intro.md" data)]
             ["LICENSE" (render "LICENSE" data)]

             ["project.clj" (render "project.clj" data)]
             ["profiles.clj" (render "profiles.clj" data)]

             ["dev/resources/index.html" (render "index.html" data)]
             ["dev/src/clj/user.clj" (render "user.clj" data)]
             ["dev/src/clj/http/server.clj" (render "server.clj" data)]
             ["dev/src/cljs/repl/ws_repl.cljs" (render "ws_repl.cljs" data)]
             ["dev/src/js/repl.js" (render "repl.js" data)]

             ["src/cljs/{{nested-dirs}}.cljs" (render "core.cljs" data)])))
