(ns offcourse.specs.status
  (:require [cljs.spec.alpha :as spec]
            [offcourse.specs.resource]
            [offcourse.specs.course]
            [offcourse.specs.user]))

(spec/def :status/learner :user/user-name)

(spec/def :status/resources (spec/coll-of :resource/resource-url))
(spec/def :status/valid (spec/keys :req-un [:course/base-id
                                            :status/learner
                                            :status/resources]))

(spec/def :status/query (spec/or :by-resource (spec/keys :req-un [:course/base-id
                                                                  :checkpoint/checkpoint-id
                                                                  :resource/resource-url])
                                 :user-name (spec/keys :req-un [:course/base-id
                                                                :status/learner])))
