/*
 * Decompiled with CFR 0.152.
 */
package nu.zoom.ldap.eon.event;

import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import nu.zoom.ldap.eon.event.ActionValues;
import nu.zoom.util.UniqueIDGenerator;

public class ActionUtils {
    private static UniqueIDGenerator idGenerator = new UniqueIDGenerator();

    private ActionUtils() {
    }

    public static void setActionValues(Action action, ActionValues values) {
        ActionUtils.setActionValues(action, values, null);
    }

    public static void setActionValues(Action action, ActionValues values, JComponent component) {
        if (action == null) {
            throw new IllegalArgumentException("Action can not be null");
        }
        if (values == null) {
            throw new IllegalArgumentException("Values must not be null");
        }
        if (values.getName() == null) {
            throw new IllegalArgumentException("Name must not be null");
        }
        action.putValue("Name", values.getName());
        if (values.getAcceleratorKey() != null) {
            int accelKey = values.getAcceleratorKey();
            int mask = values.getAcceleratorKeyMask() != null ? values.getAcceleratorKeyMask() : 0;
            KeyStroke stroke = KeyStroke.getKeyStroke(accelKey, mask);
            action.putValue("AcceleratorKey", stroke);
            if (component != null) {
                String actionName = idGenerator.getID();
                component.getActionMap().put(actionName, action);
                component.getInputMap(0).put(stroke, actionName);
            }
        }
        if (values.getMnemonic() != null) {
            action.putValue("MnemonicKey", values.getMnemonic());
        }
        if (values.getToolTip() != null) {
            action.putValue("ShortDescription", values.getToolTip());
        }
        if (values.getIcon() != null) {
            action.putValue("SmallIcon", values.getIcon());
        }
    }
}

