/*
 * Decompiled with CFR 0.152.
 */
package nu.zoom.ldap.eon.directory.tree;

import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.swing.Icon;
import javax.swing.JOptionPane;
import nu.zoom.ldap.eon.directory.event.DirectoryEventListenerRegistry;
import nu.zoom.ldap.eon.directory.tree.DirectoryTree;
import nu.zoom.ldap.eon.directory.tree.DirectoryTreeObject;
import nu.zoom.ldap.eon.directory.tree.DirectoryTreePopUpItem;
import nu.zoom.swing.desktop.Workbench;
import org.ops4j.gaderian.Messages;

public class RenameItem
implements DirectoryTreePopUpItem {
    private Messages messages;
    private Workbench workbench;
    private DirectoryEventListenerRegistry eventRegistry;

    public RenameItem(Messages messages, Workbench workbench, DirectoryEventListenerRegistry eventRegistry) {
        this.messages = messages;
        this.workbench = workbench;
        this.eventRegistry = eventRegistry;
    }

    @Override
    public void activate(DirectoryTree tree) {
        DirectoryTreeObject[] selectedNodes = null;
        try {
            selectedNodes = tree.getSelectedNodes();
        }
        catch (NamingException e) {
            selectedNodes = null;
        }
        if (selectedNodes != null && selectedNodes.length > 0) {
            DirectoryTreeObject nodeToRename = selectedNodes[0];
            Name sourceName = nodeToRename.getDistinguishedName();
            Name sourceRDN = sourceName.getSuffix(sourceName.size() - 1);
            String oldName = sourceRDN.toString();
            int typeBreak = oldName.indexOf(61);
            if (typeBreak > 0) {
                String newName = JOptionPane.showInputDialog(this.workbench.getDialogOwner(), this.messages.format("tree.popup.rename.message", (Object)oldName), oldName.substring(typeBreak + 1, oldName.length()));
                if (newName != null && newName.trim().length() > 0) {
                    if (newName.indexOf(47) != -1) {
                        newName = newName.replaceAll("/", "\\/");
                    }
                    String namingAttributeID = oldName.substring(0, typeBreak);
                    String newRDN = namingAttributeID + "=" + newName;
                    Name targetName = sourceName.getPrefix(sourceName.size() - 1);
                    try {
                        targetName.add(newRDN);
                        tree.getConnection().rename(sourceName, targetName);
                        Name parentName = targetName.getPrefix(targetName.size() - 1);
                        this.eventRegistry.fireStructureChanged(tree.getConnectionInformation().getGUID(), parentName);
                    }
                    catch (InvalidNameException e1) {
                        this.workbench.getErrorReporter().reportError(this.messages.format("tree.popup.rename.parseerror", (Object)newRDN), (Exception)e1);
                    }
                    catch (NamingException e) {
                        this.workbench.getErrorReporter().reportError(this.messages.format("tree.popup.rename.fail", (Object)sourceName.toString(), (Object)targetName.toString()), (Exception)e);
                    }
                }
            } else {
                this.workbench.getErrorReporter().reportError(this.messages.format("tree.popup.rename.parseerror", (Object)oldName));
            }
        }
    }

    @Override
    public String getName() {
        return this.messages.getMessage("tree.popup.rename");
    }

    @Override
    public String getToolTip() {
        return this.messages.getMessage("tree.popup.rename.tooltip");
    }

    @Override
    public Icon getIcon() {
        return null;
    }

    @Override
    public Integer getMnemonic() {
        return new Integer(113);
    }

    @Override
    public Integer getAcceleratorKey() {
        return new Integer(113);
    }

    @Override
    public Integer getAcceleratorKeyMask() {
        return null;
    }
}

